<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for re-assign asset
 */
class Reassignasset extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $Assetsid;
    public $Asset_No;
    public $Details_of_Asset;
    public $Asset_Status;
    public $Condition_Of_Asset;
    public $MDA_id;
    public $Location_id;
    public $Category;
    public $Category_Details;
    public $Category_Temp;
    public $Custodian_id;
    public $Date_of_Acquisition;
    public $Aquistion_Cost;
    public $Additional_Cost;
    public $Revaluation_Cost;
    public $Remarks;
    public $Created_By;
    public $Created_on;
    public $Updated_on;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'reassignasset';
        $this->TableName = 're-assign asset';
        $this->TableType = 'VIEW';

        // Update Table
        $this->UpdateTable = "`re-assign asset`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // Assetsid
        $this->Assetsid = new DbField('reassignasset', 're-assign asset', 'x_Assetsid', 'Assetsid', '`Assetsid`', '`Assetsid`', 3, 11, -1, false, '`Assetsid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->Assetsid->IsAutoIncrement = true; // Autoincrement field
        $this->Assetsid->IsPrimaryKey = true; // Primary key field
        $this->Assetsid->Sortable = true; // Allow sort
        $this->Assetsid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Assetsid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Assetsid->Param, "CustomMsg");
        $this->Fields['Assetsid'] = &$this->Assetsid;

        // Asset_No
        $this->Asset_No = new DbField('reassignasset', 're-assign asset', 'x_Asset_No', 'Asset_No', '`Asset_No`', '`Asset_No`', 200, 255, -1, false, '`Asset_No`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_No->Sortable = true; // Allow sort
        $this->Asset_No->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_No->Param, "CustomMsg");
        $this->Fields['Asset_No'] = &$this->Asset_No;

        // Details_of_Asset
        $this->Details_of_Asset = new DbField('reassignasset', 're-assign asset', 'x_Details_of_Asset', 'Details_of_Asset', '`Details_of_Asset`', '`Details_of_Asset`', 200, 255, -1, false, '`Details_of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Details_of_Asset->Nullable = false; // NOT NULL field
        $this->Details_of_Asset->Required = true; // Required field
        $this->Details_of_Asset->Sortable = true; // Allow sort
        $this->Details_of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Details_of_Asset->Param, "CustomMsg");
        $this->Fields['Details_of_Asset'] = &$this->Details_of_Asset;

        // Asset_Status
        $this->Asset_Status = new DbField('reassignasset', 're-assign asset', 'x_Asset_Status', 'Asset_Status', '`Asset_Status`', '`Asset_Status`', 200, 255, -1, false, '`Asset_Status`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_Status->Nullable = false; // NOT NULL field
        $this->Asset_Status->Required = true; // Required field
        $this->Asset_Status->Sortable = true; // Allow sort
        $this->Asset_Status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_Status->Param, "CustomMsg");
        $this->Fields['Asset_Status'] = &$this->Asset_Status;

        // Condition_Of_Asset
        $this->Condition_Of_Asset = new DbField('reassignasset', 're-assign asset', 'x_Condition_Of_Asset', 'Condition_Of_Asset', '`Condition_Of_Asset`', '`Condition_Of_Asset`', 200, 255, -1, false, '`Condition_Of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Condition_Of_Asset->Nullable = false; // NOT NULL field
        $this->Condition_Of_Asset->Required = true; // Required field
        $this->Condition_Of_Asset->Sortable = true; // Allow sort
        $this->Condition_Of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Condition_Of_Asset->Param, "CustomMsg");
        $this->Fields['Condition_Of_Asset'] = &$this->Condition_Of_Asset;

        // MDA_id
        $this->MDA_id = new DbField('reassignasset', 're-assign asset', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], [], ["x_Location_id","x_Custodian_id"], [], [], [], [], '`MDA_Acronym`', '');
                break;
            default:
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], [], ["x_Location_id","x_Custodian_id"], [], [], [], [], '`MDA_Acronym`', '');
                break;
        }
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Location_id
        $this->Location_id = new DbField('reassignasset', 're-assign asset', 'x_Location_id', 'Location_id', '`Location_id`', '`Location_id`', 3, 100, -1, false, '`Location_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Location_id->Nullable = false; // NOT NULL field
        $this->Location_id->Required = true; // Required field
        $this->Location_id->Sortable = true; // Allow sort
        $this->Location_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Location_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
            default:
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
        }
        $this->Location_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Location_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Location_id->Param, "CustomMsg");
        $this->Fields['Location_id'] = &$this->Location_id;

        // Category
        $this->Category = new DbField('reassignasset', 're-assign asset', 'x_Category', 'Category', '`Category`', '`Category`', 200, 20, -1, false, '`Category`', false, false, false, 'FORMATTED TEXT', 'CHECKBOX');
        $this->Category->Nullable = false; // NOT NULL field
        $this->Category->Required = true; // Required field
        $this->Category->Sortable = true; // Allow sort
        switch ($CurrentLanguage) {
            case "en":
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', true, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '`Categoryid`', '');
                break;
            default:
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', true, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '`Categoryid`', '');
                break;
        }
        $this->Category->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category->Param, "CustomMsg");
        $this->Fields['Category'] = &$this->Category;

        // Category_Details
        $this->Category_Details = new DbField('reassignasset', 're-assign asset', 'x_Category_Details', 'Category_Details', '`Category_Details`', '`Category_Details`', 200, 255, -1, false, '`Category_Details`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Category_Details->Sortable = true; // Allow sort
        $this->Category_Details->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Details->Param, "CustomMsg");
        $this->Fields['Category_Details'] = &$this->Category_Details;

        // Category_Temp
        $this->Category_Temp = new DbField('reassignasset', 're-assign asset', 'x_Category_Temp', 'Category_Temp', '`Category_Temp`', '`Category_Temp`', 200, 255, -1, false, '`Category_Temp`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Category_Temp->Nullable = false; // NOT NULL field
        $this->Category_Temp->Required = true; // Required field
        $this->Category_Temp->Sortable = true; // Allow sort
        $this->Category_Temp->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Temp->Param, "CustomMsg");
        $this->Fields['Category_Temp'] = &$this->Category_Temp;

        // Custodian_id
        $this->Custodian_id = new DbField('reassignasset', 're-assign asset', 'x_Custodian_id', 'Custodian_id', '`Custodian_id`', '`Custodian_id`', 3, 100, -1, false, '`Custodian_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Custodian_id->Required = true; // Required field
        $this->Custodian_id->Sortable = true; // Allow sort
        $this->Custodian_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Custodian_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', true, 'id', ["Lastname","Firstname","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Lastname`', '');
                break;
            default:
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', true, 'id', ["Lastname","Firstname","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Lastname`', '');
                break;
        }
        $this->Custodian_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Custodian_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Custodian_id->Param, "CustomMsg");
        $this->Fields['Custodian_id'] = &$this->Custodian_id;

        // Date_of_Acquisition
        $this->Date_of_Acquisition = new DbField('reassignasset', 're-assign asset', 'x_Date_of_Acquisition', 'Date_of_Acquisition', '`Date_of_Acquisition`', CastDateFieldForLike("`Date_of_Acquisition`", 0, "DB"), 133, 10, 0, false, '`Date_of_Acquisition`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Date_of_Acquisition->Nullable = false; // NOT NULL field
        $this->Date_of_Acquisition->Required = true; // Required field
        $this->Date_of_Acquisition->Sortable = true; // Allow sort
        $this->Date_of_Acquisition->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_of_Acquisition->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Date_of_Acquisition->Param, "CustomMsg");
        $this->Fields['Date_of_Acquisition'] = &$this->Date_of_Acquisition;

        // Aquistion_Cost
        $this->Aquistion_Cost = new DbField('reassignasset', 're-assign asset', 'x_Aquistion_Cost', 'Aquistion_Cost', '`Aquistion_Cost`', '`Aquistion_Cost`', 5, 22, -1, false, '`Aquistion_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Aquistion_Cost->Nullable = false; // NOT NULL field
        $this->Aquistion_Cost->Required = true; // Required field
        $this->Aquistion_Cost->Sortable = true; // Allow sort
        $this->Aquistion_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Aquistion_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Aquistion_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Aquistion_Cost->Param, "CustomMsg");
        $this->Fields['Aquistion_Cost'] = &$this->Aquistion_Cost;

        // Additional_Cost
        $this->Additional_Cost = new DbField('reassignasset', 're-assign asset', 'x_Additional_Cost', 'Additional_Cost', '`Additional_Cost`', '`Additional_Cost`', 5, 22, -1, false, '`Additional_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Additional_Cost->Sortable = true; // Allow sort
        $this->Additional_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Additional_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Additional_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Additional_Cost->Param, "CustomMsg");
        $this->Fields['Additional_Cost'] = &$this->Additional_Cost;

        // Revaluation_Cost
        $this->Revaluation_Cost = new DbField('reassignasset', 're-assign asset', 'x_Revaluation_Cost', 'Revaluation_Cost', '`Revaluation_Cost`', '`Revaluation_Cost`', 5, 22, -1, false, '`Revaluation_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Revaluation_Cost->Sortable = true; // Allow sort
        $this->Revaluation_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Revaluation_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Revaluation_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Revaluation_Cost->Param, "CustomMsg");
        $this->Fields['Revaluation_Cost'] = &$this->Revaluation_Cost;

        // Remarks
        $this->Remarks = new DbField('reassignasset', 're-assign asset', 'x_Remarks', 'Remarks', '`Remarks`', '`Remarks`', 201, -1, -1, false, '`Remarks`', false, false, false, 'FORMATTED TEXT', 'TEXTAREA');
        $this->Remarks->Sortable = true; // Allow sort
        $this->Remarks->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Remarks->Param, "CustomMsg");
        $this->Fields['Remarks'] = &$this->Remarks;

        // Created_By
        $this->Created_By = new DbField('reassignasset', 're-assign asset', 'x_Created_By', 'Created_By', '`Created_By`', '`Created_By`', 3, 11, -1, false, '`Created_By`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_By->Sortable = true; // Allow sort
        $this->Created_By->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Created_By->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_By->Param, "CustomMsg");
        $this->Fields['Created_By'] = &$this->Created_By;

        // Created_on
        $this->Created_on = new DbField('reassignasset', 're-assign asset', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "DB"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('reassignasset', 're-assign asset', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "DB"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`re-assign asset`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->Assetsid->setDbValue($conn->lastInsertId());
            $rs['Assetsid'] = $this->Assetsid->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Assetsid', $rs)) {
                AddFilter($where, QuotedName('Assetsid', $this->Dbid) . '=' . QuotedValue($rs['Assetsid'], $this->Assetsid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Assetsid->DbValue = $row['Assetsid'];
        $this->Asset_No->DbValue = $row['Asset_No'];
        $this->Details_of_Asset->DbValue = $row['Details_of_Asset'];
        $this->Asset_Status->DbValue = $row['Asset_Status'];
        $this->Condition_Of_Asset->DbValue = $row['Condition_Of_Asset'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->Location_id->DbValue = $row['Location_id'];
        $this->Category->DbValue = $row['Category'];
        $this->Category_Details->DbValue = $row['Category_Details'];
        $this->Category_Temp->DbValue = $row['Category_Temp'];
        $this->Custodian_id->DbValue = $row['Custodian_id'];
        $this->Date_of_Acquisition->DbValue = $row['Date_of_Acquisition'];
        $this->Aquistion_Cost->DbValue = $row['Aquistion_Cost'];
        $this->Additional_Cost->DbValue = $row['Additional_Cost'];
        $this->Revaluation_Cost->DbValue = $row['Revaluation_Cost'];
        $this->Remarks->DbValue = $row['Remarks'];
        $this->Created_By->DbValue = $row['Created_By'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Assetsid` = @Assetsid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Assetsid->CurrentValue : $this->Assetsid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Assetsid->CurrentValue = $keys[0];
            } else {
                $this->Assetsid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Assetsid', $row) ? $row['Assetsid'] : null;
        } else {
            $val = $this->Assetsid->OldValue !== null ? $this->Assetsid->OldValue : $this->Assetsid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Assetsid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("reassignassetlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "reassignassetview") {
            return $Language->phrase("View");
        } elseif ($pageName == "reassignassetedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "reassignassetadd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "ReassignassetView";
            case Config("API_ADD_ACTION"):
                return "ReassignassetAdd";
            case Config("API_EDIT_ACTION"):
                return "ReassignassetEdit";
            case Config("API_DELETE_ACTION"):
                return "ReassignassetDelete";
            case Config("API_LIST_ACTION"):
                return "ReassignassetList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "reassignassetlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("reassignassetview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("reassignassetview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "reassignassetadd?" . $this->getUrlParm($parm);
        } else {
            $url = "reassignassetadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("reassignassetedit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("reassignassetadd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("reassignassetdelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "Assetsid:" . JsonEncode($this->Assetsid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Assetsid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->Assetsid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Assetsid") ?? Route("Assetsid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Assetsid->CurrentValue = $key;
            } else {
                $this->Assetsid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Assetsid->setDbValue($row['Assetsid']);
        $this->Asset_No->setDbValue($row['Asset_No']);
        $this->Details_of_Asset->setDbValue($row['Details_of_Asset']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->Category->setDbValue($row['Category']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Category_Temp->setDbValue($row['Category_Temp']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($row['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($row['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($row['Revaluation_Cost']);
        $this->Remarks->setDbValue($row['Remarks']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Assetsid

        // Asset_No

        // Details_of_Asset

        // Asset_Status

        // Condition_Of_Asset

        // MDA_id

        // Location_id

        // Category

        // Category_Details

        // Category_Temp

        // Custodian_id

        // Date_of_Acquisition

        // Aquistion_Cost

        // Additional_Cost

        // Revaluation_Cost

        // Remarks

        // Created_By

        // Created_on

        // Updated_on

        // Assetsid
        $this->Assetsid->ViewValue = $this->Assetsid->CurrentValue;
        $this->Assetsid->ViewCustomAttributes = "";

        // Asset_No
        $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
        $this->Asset_No->ViewCustomAttributes = "";

        // Details_of_Asset
        $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
        $this->Details_of_Asset->ViewCustomAttributes = "";

        // Asset_Status
        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
        $this->Asset_Status->ViewCustomAttributes = "";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
        $this->Condition_Of_Asset->ViewCustomAttributes = "";

        // MDA_id
        $curVal = trim(strval($this->MDA_id->CurrentValue));
        if ($curVal != "") {
            $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
            if ($this->MDA_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                    $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                } else {
                    $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                }
            }
        } else {
            $this->MDA_id->ViewValue = null;
        }
        $this->MDA_id->ViewCustomAttributes = "";

        // Location_id
        $curVal = trim(strval($this->Location_id->CurrentValue));
        if ($curVal != "") {
            $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            if ($this->Location_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                } else {
                    $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                }
            }
        } else {
            $this->Location_id->ViewValue = null;
        }
        $this->Location_id->ViewCustomAttributes = "";

        // Category
        $curVal = trim(strval($this->Category->CurrentValue));
        if ($curVal != "") {
            $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
            if ($this->Category->ViewValue === null) { // Lookup from database
                $arwrk = explode(",", $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    if ($filterWrk != "") {
                        $filterWrk .= " OR ";
                    }
                    $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->Category->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->Category->Lookup->renderViewRow($row);
                        $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                    }
                } else {
                    $this->Category->ViewValue = $this->Category->CurrentValue;
                }
            }
        } else {
            $this->Category->ViewValue = null;
        }
        $this->Category->ViewCustomAttributes = "";

        // Category_Details
        $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
        $this->Category_Details->ViewCustomAttributes = "";

        // Category_Temp
        $this->Category_Temp->ViewValue = $this->Category_Temp->CurrentValue;
        $this->Category_Temp->ViewCustomAttributes = "";

        // Custodian_id
        $curVal = trim(strval($this->Custodian_id->CurrentValue));
        if ($curVal != "") {
            $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Custodian_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Custodian_id->ViewValue = $this->Custodian_id->displayValue($arwrk);
                } else {
                    $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                }
            }
        } else {
            $this->Custodian_id->ViewValue = null;
        }
        $this->Custodian_id->ViewCustomAttributes = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
        $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
        $this->Date_of_Acquisition->ViewCustomAttributes = "";

        // Aquistion_Cost
        $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
        $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -2, -2);
        $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
        $this->Aquistion_Cost->ViewCustomAttributes = "";

        // Additional_Cost
        $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
        $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
        $this->Additional_Cost->CellCssStyle .= "text-align: right;";
        $this->Additional_Cost->ViewCustomAttributes = "";

        // Revaluation_Cost
        $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
        $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
        $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
        $this->Revaluation_Cost->ViewCustomAttributes = "";

        // Remarks
        $this->Remarks->ViewValue = $this->Remarks->CurrentValue;
        $this->Remarks->ViewCustomAttributes = "";

        // Created_By
        $this->Created_By->ViewValue = $this->Created_By->CurrentValue;
        $this->Created_By->ViewValue = FormatNumber($this->Created_By->ViewValue, 0, -2, -2, -2);
        $this->Created_By->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // Assetsid
        $this->Assetsid->LinkCustomAttributes = "";
        $this->Assetsid->HrefValue = "";
        $this->Assetsid->TooltipValue = "";

        // Asset_No
        $this->Asset_No->LinkCustomAttributes = "";
        $this->Asset_No->HrefValue = "";
        $this->Asset_No->TooltipValue = "";

        // Details_of_Asset
        $this->Details_of_Asset->LinkCustomAttributes = "";
        $this->Details_of_Asset->HrefValue = "";
        $this->Details_of_Asset->TooltipValue = "";

        // Asset_Status
        $this->Asset_Status->LinkCustomAttributes = "";
        $this->Asset_Status->HrefValue = "";
        $this->Asset_Status->TooltipValue = "";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->LinkCustomAttributes = "";
        $this->Condition_Of_Asset->HrefValue = "";
        $this->Condition_Of_Asset->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Location_id
        $this->Location_id->LinkCustomAttributes = "";
        $this->Location_id->HrefValue = "";
        $this->Location_id->TooltipValue = "";

        // Category
        $this->Category->LinkCustomAttributes = "";
        $this->Category->HrefValue = "";
        $this->Category->TooltipValue = "";

        // Category_Details
        $this->Category_Details->LinkCustomAttributes = "";
        $this->Category_Details->HrefValue = "";
        $this->Category_Details->TooltipValue = "";

        // Category_Temp
        $this->Category_Temp->LinkCustomAttributes = "";
        $this->Category_Temp->HrefValue = "";
        $this->Category_Temp->TooltipValue = "";

        // Custodian_id
        $this->Custodian_id->LinkCustomAttributes = "";
        $this->Custodian_id->HrefValue = "";
        $this->Custodian_id->TooltipValue = "";

        // Date_of_Acquisition
        $this->Date_of_Acquisition->LinkCustomAttributes = "";
        $this->Date_of_Acquisition->HrefValue = "";
        $this->Date_of_Acquisition->TooltipValue = "";

        // Aquistion_Cost
        $this->Aquistion_Cost->LinkCustomAttributes = "";
        $this->Aquistion_Cost->HrefValue = "";
        $this->Aquistion_Cost->TooltipValue = "";

        // Additional_Cost
        $this->Additional_Cost->LinkCustomAttributes = "";
        $this->Additional_Cost->HrefValue = "";
        $this->Additional_Cost->TooltipValue = "";

        // Revaluation_Cost
        $this->Revaluation_Cost->LinkCustomAttributes = "";
        $this->Revaluation_Cost->HrefValue = "";
        $this->Revaluation_Cost->TooltipValue = "";

        // Remarks
        $this->Remarks->LinkCustomAttributes = "";
        $this->Remarks->HrefValue = "";
        $this->Remarks->TooltipValue = "";

        // Created_By
        $this->Created_By->LinkCustomAttributes = "";
        $this->Created_By->HrefValue = "";
        $this->Created_By->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Assetsid
        $this->Assetsid->EditAttrs["class"] = "form-control";
        $this->Assetsid->EditCustomAttributes = "";
        $this->Assetsid->EditValue = $this->Assetsid->CurrentValue;
        $this->Assetsid->ViewCustomAttributes = "";

        // Asset_No
        $this->Asset_No->EditAttrs["class"] = "form-control";
        $this->Asset_No->EditCustomAttributes = "";
        if (!$this->Asset_No->Raw) {
            $this->Asset_No->CurrentValue = HtmlDecode($this->Asset_No->CurrentValue);
        }
        $this->Asset_No->EditValue = $this->Asset_No->CurrentValue;
        $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

        // Details_of_Asset
        $this->Details_of_Asset->EditAttrs["class"] = "form-control";
        $this->Details_of_Asset->EditCustomAttributes = "";
        if (!$this->Details_of_Asset->Raw) {
            $this->Details_of_Asset->CurrentValue = HtmlDecode($this->Details_of_Asset->CurrentValue);
        }
        $this->Details_of_Asset->EditValue = $this->Details_of_Asset->CurrentValue;
        $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

        // Asset_Status
        $this->Asset_Status->EditAttrs["class"] = "form-control";
        $this->Asset_Status->EditCustomAttributes = "";
        if (!$this->Asset_Status->Raw) {
            $this->Asset_Status->CurrentValue = HtmlDecode($this->Asset_Status->CurrentValue);
        }
        $this->Asset_Status->EditValue = $this->Asset_Status->CurrentValue;
        $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

        // Condition_Of_Asset
        $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
        $this->Condition_Of_Asset->EditCustomAttributes = "";
        if (!$this->Condition_Of_Asset->Raw) {
            $this->Condition_Of_Asset->CurrentValue = HtmlDecode($this->Condition_Of_Asset->CurrentValue);
        }
        $this->Condition_Of_Asset->EditValue = $this->Condition_Of_Asset->CurrentValue;
        $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
            $this->MDA_id->CurrentValue = CurrentUserID();
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->EditValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";
        } else {
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
        }

        // Location_id
        $this->Location_id->EditAttrs["class"] = "form-control";
        $this->Location_id->EditCustomAttributes = "";
        $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

        // Category
        $this->Category->EditCustomAttributes = "";
        $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

        // Category_Details
        $this->Category_Details->EditAttrs["class"] = "form-control";
        $this->Category_Details->EditCustomAttributes = "";
        if (!$this->Category_Details->Raw) {
            $this->Category_Details->CurrentValue = HtmlDecode($this->Category_Details->CurrentValue);
        }
        $this->Category_Details->EditValue = $this->Category_Details->CurrentValue;
        $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

        // Category_Temp
        $this->Category_Temp->EditAttrs["class"] = "form-control";
        $this->Category_Temp->EditCustomAttributes = "";
        if (!$this->Category_Temp->Raw) {
            $this->Category_Temp->CurrentValue = HtmlDecode($this->Category_Temp->CurrentValue);
        }
        $this->Category_Temp->EditValue = $this->Category_Temp->CurrentValue;
        $this->Category_Temp->PlaceHolder = RemoveHtml($this->Category_Temp->caption());

        // Custodian_id
        $this->Custodian_id->EditAttrs["class"] = "form-control";
        $this->Custodian_id->EditCustomAttributes = "";
        $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

        // Date_of_Acquisition
        $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
        $this->Date_of_Acquisition->EditCustomAttributes = "";
        $this->Date_of_Acquisition->EditValue = FormatDateTime($this->Date_of_Acquisition->CurrentValue, 8);
        $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

        // Aquistion_Cost
        $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
        $this->Aquistion_Cost->EditCustomAttributes = "";
        $this->Aquistion_Cost->EditValue = $this->Aquistion_Cost->CurrentValue;
        $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
        if (strval($this->Aquistion_Cost->EditValue) != "" && is_numeric($this->Aquistion_Cost->EditValue)) {
            $this->Aquistion_Cost->EditValue = FormatNumber($this->Aquistion_Cost->EditValue, -2, -2, -2, -2);
        }

        // Additional_Cost
        $this->Additional_Cost->EditAttrs["class"] = "form-control";
        $this->Additional_Cost->EditCustomAttributes = "";
        $this->Additional_Cost->EditValue = $this->Additional_Cost->CurrentValue;
        $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());
        if (strval($this->Additional_Cost->EditValue) != "" && is_numeric($this->Additional_Cost->EditValue)) {
            $this->Additional_Cost->EditValue = FormatNumber($this->Additional_Cost->EditValue, -2, -2, -2, -2);
        }

        // Revaluation_Cost
        $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
        $this->Revaluation_Cost->EditCustomAttributes = "";
        $this->Revaluation_Cost->EditValue = $this->Revaluation_Cost->CurrentValue;
        $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());
        if (strval($this->Revaluation_Cost->EditValue) != "" && is_numeric($this->Revaluation_Cost->EditValue)) {
            $this->Revaluation_Cost->EditValue = FormatNumber($this->Revaluation_Cost->EditValue, -2, -2, -2, -2);
        }

        // Remarks
        $this->Remarks->EditAttrs["class"] = "form-control";
        $this->Remarks->EditCustomAttributes = "";
        $this->Remarks->EditValue = $this->Remarks->CurrentValue;
        $this->Remarks->PlaceHolder = RemoveHtml($this->Remarks->caption());

        // Created_By
        $this->Created_By->EditAttrs["class"] = "form-control";
        $this->Created_By->EditCustomAttributes = "";
        $this->Created_By->EditValue = $this->Created_By->CurrentValue;
        $this->Created_By->PlaceHolder = RemoveHtml($this->Created_By->caption());

        // Created_on
        $this->Created_on->EditAttrs["class"] = "form-control";
        $this->Created_on->EditCustomAttributes = "";
        $this->Created_on->EditValue = FormatDateTime($this->Created_on->CurrentValue, 8);
        $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());

        // Updated_on
        $this->Updated_on->EditAttrs["class"] = "form-control";
        $this->Updated_on->EditCustomAttributes = "";
        $this->Updated_on->EditValue = FormatDateTime($this->Updated_on->CurrentValue, 8);
        $this->Updated_on->PlaceHolder = RemoveHtml($this->Updated_on->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Assetsid);
                    $doc->exportCaption($this->Asset_No);
                    $doc->exportCaption($this->Details_of_Asset);
                    $doc->exportCaption($this->Asset_Status);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Category);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Category_Temp);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->Aquistion_Cost);
                    $doc->exportCaption($this->Additional_Cost);
                    $doc->exportCaption($this->Revaluation_Cost);
                    $doc->exportCaption($this->Remarks);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                } else {
                    $doc->exportCaption($this->Assetsid);
                    $doc->exportCaption($this->Asset_No);
                    $doc->exportCaption($this->Details_of_Asset);
                    $doc->exportCaption($this->Asset_Status);
                    $doc->exportCaption($this->Condition_Of_Asset);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Location_id);
                    $doc->exportCaption($this->Category);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Category_Temp);
                    $doc->exportCaption($this->Custodian_id);
                    $doc->exportCaption($this->Date_of_Acquisition);
                    $doc->exportCaption($this->Aquistion_Cost);
                    $doc->exportCaption($this->Additional_Cost);
                    $doc->exportCaption($this->Revaluation_Cost);
                    $doc->exportCaption($this->Created_By);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Assetsid);
                        $doc->exportField($this->Asset_No);
                        $doc->exportField($this->Details_of_Asset);
                        $doc->exportField($this->Asset_Status);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Category);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Category_Temp);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->Aquistion_Cost);
                        $doc->exportField($this->Additional_Cost);
                        $doc->exportField($this->Revaluation_Cost);
                        $doc->exportField($this->Remarks);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    } else {
                        $doc->exportField($this->Assetsid);
                        $doc->exportField($this->Asset_No);
                        $doc->exportField($this->Details_of_Asset);
                        $doc->exportField($this->Asset_Status);
                        $doc->exportField($this->Condition_Of_Asset);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Location_id);
                        $doc->exportField($this->Category);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Category_Temp);
                        $doc->exportField($this->Custodian_id);
                        $doc->exportField($this->Date_of_Acquisition);
                        $doc->exportField($this->Aquistion_Cost);
                        $doc->exportField($this->Additional_Cost);
                        $doc->exportField($this->Revaluation_Cost);
                        $doc->exportField($this->Created_By);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `re-assign asset`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
    // 
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
    // Get userid. Ignoring Default user function. This is secured !
        // I did this coz MDA_id was use as fliter for all users'
        $username= CurrentUsername();
        $myRow = ExecuteRow("SELECT userid FROM reportuserstbl WHERE Username  = '$username'");
         $userid = $myRow["userid"];
        //Log("Row Updated");
      $assetid=  $rsold["Assetsid"] ;

    	//$reassignerid=$userid;
    $reciverid=	$rsnew["Custodian_id"] ;
    $prevcustodian=	$rsold["Custodian_id"] ;
    	$MDAid=	$rsnew["MDA_id"] ;

      //safe a unique figure for each transaction. Use timstamp .
     // we can now filter by this unique figure from this table
    $timesammp=DATE("dmyHis");		
    $transactionid = $timesammp;   
    $url='print2?transactionid='.$transactionid.'';
    // Insert record
    $myResult = ExecuteUpdate("INSERT INTO custodianmovementtbl
     (	asset_id, reassignerid,Prev_Custodian_id,reciverid,MDA_id,transactionid,url)
     VALUES ('$assetid', '$userid','$prevcustodian','$reciverid','$MDAid','$transactionid','$url')");

    //$myResult = ExecuteUpdate("INSERT INTO verifyassettbl (transactionid, Previous_Custodian) VALUES ('$transactionid', '$userid')");

     //$myResult = ExecuteUpdate("INSERT INTO verifyassettbl (transactionid) VALUES ('$transactionid')");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
