<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Slim\Views\PhpRenderer;
use Slim\Csrf\Guard;
use Psr\Container\ContainerInterface;
use Monolog\Logger;
use Monolog\Handler\RotatingFileHandler;
use Doctrine\DBAL\Logging\LoggerChain;
use Doctrine\DBAL\Logging\DebugStack;

return [
    "cache" => function (ContainerInterface $c) {
        return new \Slim\HttpCache\CacheProvider();
    },
    "view" => function (ContainerInterface $c) {
        return new PhpRenderer("views/");
    },
    "flash" => function (ContainerInterface $c) {
        return new \Slim\Flash\Messages();
    },
    "audit" => function (ContainerInterface $c) {
        $logger = new Logger("audit"); // For audit trail
        $logger->pushHandler(new AuditTrailHandler("audit.log"));
        return $logger;
    },
    "log" => function (ContainerInterface $c) {
        global $RELATIVE_PATH;
        $logger = new Logger("log");
        $logger->pushHandler(new RotatingFileHandler($RELATIVE_PATH . "log.log"));
        return $logger;
    },
    "sqllogger" => function (ContainerInterface $c) {
        $loggers = [];
        if (Config("DEBUG")) {
            $loggers[] = $c->get("debugstack");
        }
        return (count($loggers) > 0) ? new LoggerChain($loggers) : null;
    },
    "csrf" => function (ContainerInterface $c) {
        global $ResponseFactory;
        return new Guard($ResponseFactory, Config("CSRF_PREFIX"));
    },
    "debugstack" => \DI\create(DebugStack::class),
    "debugsqllogger" => \DI\create(DebugSqlLogger::class),
    "security" => \DI\create(AdvancedSecurity::class),
    "profile" => \DI\create(UserProfile::class),
    "language" => \DI\create(Language::class),
    "timer" => \DI\create(Timer::class),
    "session" => \DI\create(HttpSession::class),

    // Tables
    "locationtbl" => \DI\create(Locationtbl::class),
    "assetstbl" => \DI\create(Assetstbl::class),
    "categorydetailstbl" => \DI\create(Categorydetailstbl::class),
    "categorytbl" => \DI\create(Categorytbl::class),
    "reportuserstbl" => \DI\create(Reportuserstbl::class),
    "custodianstbl" => \DI\create(Custodianstbl::class),
    "mdatbl" => \DI\create(Mdatbl::class),
    "condition_of_assettbl" => \DI\create(ConditionOfAssettbl::class),
    "allremarkstbl" => \DI\create(Allremarkstbl::class),
    "asset_staustbl" => \DI\create(AssetStaustbl::class),
    "summaryreport3" => \DI\create(Summaryreport3::class),
    "SummaryReport" => \DI\create(SummaryReport::class),
    "assetconditionvaluationtbl" => \DI\create(Assetconditionvaluationtbl::class),
    "inflationratestbl" => \DI\create(Inflationratestbl::class),
    "DetailedReport" => \DI\create(DetailedReport::class),
    "reassignasset" => \DI\create(Reassignasset::class),
    "motorvehiclereport" => \DI\create(Motorvehiclereport::class),
    "MotorVehicleReport2" => \DI\create(MotorVehicleReport2::class),
    "moveasset" => \DI\create(Moveasset::class),
    "assetsaudittrailtbl" => \DI\create(Assetsaudittrailtbl::class),
    "Assetlog" => \DI\create(Assetlog::class),
    "make" => \DI\create(Make::class),
    "model" => \DI\create(Model::class),
    "detail" => \DI\create(Detail::class),
    "Dashboard2" => \DI\create(Dashboard2::class),
    "verifyassettbl" => \DI\create(Verifyassettbl::class),
    "custodianmovementtbl" => \DI\create(Custodianmovementtbl::class),
    "selected" => \DI\create(Selected::class),
    "selectedmdas2" => \DI\create(Selectedmdas2::class),
    "SelectedMDAs" => \DI\create(SelectedMdAs::class),
    "verifyasset" => \DI\create(Verifyasset::class),
    "print2" => \DI\create(Print2::class),
    "verifyassets" => \DI\create(Verifyassets::class),
    "directorytbl" => \DI\create(Directorytbl::class),
    "printassets" => \DI\create(Printassets::class),

    // User table
    "usertable" => \DI\get("reportuserstbl"),
];
