<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for reportuserstbl
 */
class Reportuserstbl extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Export
    public $ExportDoc;

    // Fields
    public $_userid;
    public $Lastname;
    public $Firstname;
    public $Othername;
    public $Status;
    public $_Email;
    public $Phone_Number;
    public $_Username;
    public $_Password;
    public $_Userlevel;
    public $MDA_id;
    public $__session;
    public $Created_on;
    public $Updated_on;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'reportuserstbl';
        $this->TableName = 'reportuserstbl';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`reportuserstbl`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = 50; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // userid
        $this->_userid = new DbField('reportuserstbl', 'reportuserstbl', 'x__userid', 'userid', '`userid`', '`userid`', 3, 11, -1, false, '`userid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->_userid->IsAutoIncrement = true; // Autoincrement field
        $this->_userid->IsPrimaryKey = true; // Primary key field
        $this->_userid->Sortable = true; // Allow sort
        $this->_userid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_userid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_userid->Param, "CustomMsg");
        $this->Fields['userid'] = &$this->_userid;

        // Lastname
        $this->Lastname = new DbField('reportuserstbl', 'reportuserstbl', 'x_Lastname', 'Lastname', '`Lastname`', '`Lastname`', 200, 100, -1, false, '`Lastname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Lastname->Nullable = false; // NOT NULL field
        $this->Lastname->Required = true; // Required field
        $this->Lastname->Sortable = true; // Allow sort
        $this->Lastname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Lastname->Param, "CustomMsg");
        $this->Fields['Lastname'] = &$this->Lastname;

        // Firstname
        $this->Firstname = new DbField('reportuserstbl', 'reportuserstbl', 'x_Firstname', 'Firstname', '`Firstname`', '`Firstname`', 200, 100, -1, false, '`Firstname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Firstname->Nullable = false; // NOT NULL field
        $this->Firstname->Required = true; // Required field
        $this->Firstname->Sortable = true; // Allow sort
        $this->Firstname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Firstname->Param, "CustomMsg");
        $this->Fields['Firstname'] = &$this->Firstname;

        // Othername
        $this->Othername = new DbField('reportuserstbl', 'reportuserstbl', 'x_Othername', 'Othername', '`Othername`', '`Othername`', 200, 100, -1, false, '`Othername`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Othername->Nullable = false; // NOT NULL field
        $this->Othername->Required = true; // Required field
        $this->Othername->Sortable = true; // Allow sort
        $this->Othername->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Othername->Param, "CustomMsg");
        $this->Fields['Othername'] = &$this->Othername;

        // Status
        $this->Status = new DbField('reportuserstbl', 'reportuserstbl', 'x_Status', 'Status', '`Status`', '`Status`', 3, 11, -1, false, '`Status`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Status->Nullable = false; // NOT NULL field
        $this->Status->Required = true; // Required field
        $this->Status->Sortable = true; // Allow sort
        $this->Status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Status->Lookup = new Lookup('Status', 'reportuserstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->Status->Lookup = new Lookup('Status', 'reportuserstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->Status->OptionCount = 2;
        $this->Status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Status->Param, "CustomMsg");
        $this->Fields['Status'] = &$this->Status;

        // Email
        $this->_Email = new DbField('reportuserstbl', 'reportuserstbl', 'x__Email', 'Email', '`Email`', '`Email`', 200, 255, -1, false, '`Email`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->_Email->Sortable = true; // Allow sort
        $this->_Email->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_Email->Param, "CustomMsg");
        $this->Fields['Email'] = &$this->_Email;

        // Phone_Number
        $this->Phone_Number = new DbField('reportuserstbl', 'reportuserstbl', 'x_Phone_Number', 'Phone_Number', '`Phone_Number`', '`Phone_Number`', 200, 20, -1, false, '`Phone_Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Phone_Number->Nullable = false; // NOT NULL field
        $this->Phone_Number->Required = true; // Required field
        $this->Phone_Number->Sortable = true; // Allow sort
        $this->Phone_Number->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Phone_Number->Param, "CustomMsg");
        $this->Fields['Phone_Number'] = &$this->Phone_Number;

        // Username
        $this->_Username = new DbField('reportuserstbl', 'reportuserstbl', 'x__Username', 'Username', '`Username`', '`Username`', 200, 50, -1, false, '`Username`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->_Username->Nullable = false; // NOT NULL field
        $this->_Username->Required = true; // Required field
        $this->_Username->Sortable = true; // Allow sort
        $this->_Username->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_Username->Param, "CustomMsg");
        $this->Fields['Username'] = &$this->_Username;

        // Password
        $this->_Password = new DbField('reportuserstbl', 'reportuserstbl', 'x__Password', 'Password', '`Password`', '`Password`', 200, 100, -1, false, '`Password`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        if (Config("ENCRYPTED_PASSWORD")) {
            $this->_Password->Raw = true;
        }
        $this->_Password->Nullable = false; // NOT NULL field
        $this->_Password->Required = true; // Required field
        $this->_Password->Sortable = true; // Allow sort
        $this->_Password->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_Password->Param, "CustomMsg");
        $this->Fields['Password'] = &$this->_Password;

        // Userlevel
        $this->_Userlevel = new DbField('reportuserstbl', 'reportuserstbl', 'x__Userlevel', 'Userlevel', '`Userlevel`', '`Userlevel`', 3, 11, -1, false, '`Userlevel`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->_Userlevel->Nullable = false; // NOT NULL field
        $this->_Userlevel->Required = true; // Required field
        $this->_Userlevel->Sortable = true; // Allow sort
        $this->_Userlevel->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->_Userlevel->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->_Userlevel->Lookup = new Lookup('Userlevel', 'reportuserstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->_Userlevel->Lookup = new Lookup('Userlevel', 'reportuserstbl', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->_Userlevel->OptionCount = 6;
        $this->_Userlevel->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_Userlevel->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_Userlevel->Param, "CustomMsg");
        $this->Fields['Userlevel'] = &$this->_Userlevel;

        // MDA_id
        $this->MDA_id = new DbField('reportuserstbl', 'reportuserstbl', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 100, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA","","",""], [], [], [], [], [], [], '`MDA`', '');
                break;
            default:
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA","","",""], [], [], [], [], [], [], '`MDA`', '');
                break;
        }
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // session
        $this->__session = new DbField('reportuserstbl', 'reportuserstbl', 'x___session', 'session', '`session`', '`session`', 200, 100, -1, false, '`session`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->__session->Sortable = true; // Allow sort
        $this->__session->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->__session->Param, "CustomMsg");
        $this->Fields['session'] = &$this->__session;

        // Created_on
        $this->Created_on = new DbField('reportuserstbl', 'reportuserstbl', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "DB"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('reportuserstbl', 'reportuserstbl', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "DB"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`reportuserstbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            if (Config("ENCRYPTED_PASSWORD") && $name == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                $value = Config("CASE_SENSITIVE_PASSWORD") ? EncryptPassword($value) : EncryptPassword(strtolower($value));
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->_userid->setDbValue($conn->lastInsertId());
            $rs['userid'] = $this->_userid->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            if (Config("ENCRYPTED_PASSWORD") && $name == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                if ($value == $this->Fields[$name]->OldValue) { // No need to update hashed password if not changed
                    continue;
                }
                $value = Config("CASE_SENSITIVE_PASSWORD") ? EncryptPassword($value) : EncryptPassword(strtolower($value));
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'userid';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('userid', $rs)) {
                AddFilter($where, QuotedName('userid', $this->Dbid) . '=' . QuotedValue($rs['userid'], $this->_userid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->_userid->DbValue = $row['userid'];
        $this->Lastname->DbValue = $row['Lastname'];
        $this->Firstname->DbValue = $row['Firstname'];
        $this->Othername->DbValue = $row['Othername'];
        $this->Status->DbValue = $row['Status'];
        $this->_Email->DbValue = $row['Email'];
        $this->Phone_Number->DbValue = $row['Phone_Number'];
        $this->_Username->DbValue = $row['Username'];
        $this->_Password->DbValue = $row['Password'];
        $this->_Userlevel->DbValue = $row['Userlevel'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->__session->DbValue = $row['session'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`userid` = @_userid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->_userid->CurrentValue : $this->_userid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->_userid->CurrentValue = $keys[0];
            } else {
                $this->_userid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('userid', $row) ? $row['userid'] : null;
        } else {
            $val = $this->_userid->OldValue !== null ? $this->_userid->OldValue : $this->_userid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@_userid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("reportuserstbllist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "reportuserstblview") {
            return $Language->phrase("View");
        } elseif ($pageName == "reportuserstbledit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "reportuserstbladd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "ReportuserstblView";
            case Config("API_ADD_ACTION"):
                return "ReportuserstblAdd";
            case Config("API_EDIT_ACTION"):
                return "ReportuserstblEdit";
            case Config("API_DELETE_ACTION"):
                return "ReportuserstblDelete";
            case Config("API_LIST_ACTION"):
                return "ReportuserstblList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "reportuserstbllist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("reportuserstblview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("reportuserstblview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "reportuserstbladd?" . $this->getUrlParm($parm);
        } else {
            $url = "reportuserstbladd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("reportuserstbledit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("reportuserstbladd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("reportuserstbldelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "_userid:" . JsonEncode($this->_userid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->_userid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->_userid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("_userid") ?? Route("_userid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->_userid->CurrentValue = $key;
            } else {
                $this->_userid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->_userid->setDbValue($row['userid']);
        $this->Lastname->setDbValue($row['Lastname']);
        $this->Firstname->setDbValue($row['Firstname']);
        $this->Othername->setDbValue($row['Othername']);
        $this->Status->setDbValue($row['Status']);
        $this->_Email->setDbValue($row['Email']);
        $this->Phone_Number->setDbValue($row['Phone_Number']);
        $this->_Username->setDbValue($row['Username']);
        $this->_Password->setDbValue($row['Password']);
        $this->_Userlevel->setDbValue($row['Userlevel']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->__session->setDbValue($row['session']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // userid

        // Lastname

        // Firstname

        // Othername

        // Status

        // Email

        // Phone_Number

        // Username

        // Password

        // Userlevel

        // MDA_id

        // session

        // Created_on

        // Updated_on

        // userid
        $this->_userid->ViewValue = $this->_userid->CurrentValue;
        $this->_userid->ViewCustomAttributes = "";

        // Lastname
        $this->Lastname->ViewValue = $this->Lastname->CurrentValue;
        $this->Lastname->ViewCustomAttributes = "";

        // Firstname
        $this->Firstname->ViewValue = $this->Firstname->CurrentValue;
        $this->Firstname->ViewCustomAttributes = "";

        // Othername
        $this->Othername->ViewValue = $this->Othername->CurrentValue;
        $this->Othername->ViewCustomAttributes = "";

        // Status
        if (strval($this->Status->CurrentValue) != "") {
            $this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
        } else {
            $this->Status->ViewValue = null;
        }
        $this->Status->ViewCustomAttributes = "";

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;
        $this->_Email->ViewCustomAttributes = "";

        // Phone_Number
        $this->Phone_Number->ViewValue = $this->Phone_Number->CurrentValue;
        $this->Phone_Number->ViewCustomAttributes = "";

        // Username
        $this->_Username->ViewValue = $this->_Username->CurrentValue;
        $this->_Username->ViewCustomAttributes = "";

        // Password
        $this->_Password->ViewValue = $this->_Password->CurrentValue;
        $this->_Password->ViewCustomAttributes = "";

        // Userlevel
        if ($Security->canAdmin()) { // System admin
            if (strval($this->_Userlevel->CurrentValue) != "") {
                $this->_Userlevel->ViewValue = $this->_Userlevel->optionCaption($this->_Userlevel->CurrentValue);
            } else {
                $this->_Userlevel->ViewValue = null;
            }
        } else {
            $this->_Userlevel->ViewValue = $Language->phrase("PasswordMask");
        }
        $this->_Userlevel->ViewCustomAttributes = "";

        // MDA_id
        $curVal = trim(strval($this->MDA_id->CurrentValue));
        if ($curVal != "") {
            $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
            if ($this->MDA_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                    $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                } else {
                    $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                }
            }
        } else {
            $this->MDA_id->ViewValue = null;
        }
        $this->MDA_id->ViewCustomAttributes = "";

        // session
        $this->__session->ViewValue = $this->__session->CurrentValue;
        $this->__session->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // userid
        $this->_userid->LinkCustomAttributes = "";
        $this->_userid->HrefValue = "";
        $this->_userid->TooltipValue = "";

        // Lastname
        $this->Lastname->LinkCustomAttributes = "";
        $this->Lastname->HrefValue = "";
        $this->Lastname->TooltipValue = "";

        // Firstname
        $this->Firstname->LinkCustomAttributes = "";
        $this->Firstname->HrefValue = "";
        $this->Firstname->TooltipValue = "";

        // Othername
        $this->Othername->LinkCustomAttributes = "";
        $this->Othername->HrefValue = "";
        $this->Othername->TooltipValue = "";

        // Status
        $this->Status->LinkCustomAttributes = "";
        $this->Status->HrefValue = "";
        $this->Status->TooltipValue = "";

        // Email
        $this->_Email->LinkCustomAttributes = "";
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // Phone_Number
        $this->Phone_Number->LinkCustomAttributes = "";
        $this->Phone_Number->HrefValue = "";
        $this->Phone_Number->TooltipValue = "";

        // Username
        $this->_Username->LinkCustomAttributes = "";
        $this->_Username->HrefValue = "";
        $this->_Username->TooltipValue = "";

        // Password
        $this->_Password->LinkCustomAttributes = "";
        $this->_Password->HrefValue = "";
        $this->_Password->TooltipValue = "";

        // Userlevel
        $this->_Userlevel->LinkCustomAttributes = "";
        $this->_Userlevel->HrefValue = "";
        $this->_Userlevel->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // session
        $this->__session->LinkCustomAttributes = "";
        $this->__session->HrefValue = "";
        $this->__session->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // userid
        $this->_userid->EditAttrs["class"] = "form-control";
        $this->_userid->EditCustomAttributes = "";
        $this->_userid->EditValue = $this->_userid->CurrentValue;
        $this->_userid->ViewCustomAttributes = "";

        // Lastname
        $this->Lastname->EditAttrs["class"] = "form-control";
        $this->Lastname->EditCustomAttributes = "";
        if (!$this->Lastname->Raw) {
            $this->Lastname->CurrentValue = HtmlDecode($this->Lastname->CurrentValue);
        }
        $this->Lastname->EditValue = $this->Lastname->CurrentValue;
        $this->Lastname->PlaceHolder = RemoveHtml($this->Lastname->caption());

        // Firstname
        $this->Firstname->EditAttrs["class"] = "form-control";
        $this->Firstname->EditCustomAttributes = "";
        if (!$this->Firstname->Raw) {
            $this->Firstname->CurrentValue = HtmlDecode($this->Firstname->CurrentValue);
        }
        $this->Firstname->EditValue = $this->Firstname->CurrentValue;
        $this->Firstname->PlaceHolder = RemoveHtml($this->Firstname->caption());

        // Othername
        $this->Othername->EditAttrs["class"] = "form-control";
        $this->Othername->EditCustomAttributes = "";
        if (!$this->Othername->Raw) {
            $this->Othername->CurrentValue = HtmlDecode($this->Othername->CurrentValue);
        }
        $this->Othername->EditValue = $this->Othername->CurrentValue;
        $this->Othername->PlaceHolder = RemoveHtml($this->Othername->caption());

        // Status
        $this->Status->EditAttrs["class"] = "form-control";
        $this->Status->EditCustomAttributes = "";
        $this->Status->EditValue = $this->Status->options(true);
        $this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

        // Email
        $this->_Email->EditAttrs["class"] = "form-control";
        $this->_Email->EditCustomAttributes = "";
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // Phone_Number
        $this->Phone_Number->EditAttrs["class"] = "form-control";
        $this->Phone_Number->EditCustomAttributes = "";
        if (!$this->Phone_Number->Raw) {
            $this->Phone_Number->CurrentValue = HtmlDecode($this->Phone_Number->CurrentValue);
        }
        $this->Phone_Number->EditValue = $this->Phone_Number->CurrentValue;
        $this->Phone_Number->PlaceHolder = RemoveHtml($this->Phone_Number->caption());

        // Username
        $this->_Username->EditAttrs["class"] = "form-control";
        $this->_Username->EditCustomAttributes = "";
        if (!$this->_Username->Raw) {
            $this->_Username->CurrentValue = HtmlDecode($this->_Username->CurrentValue);
        }
        $this->_Username->EditValue = $this->_Username->CurrentValue;
        $this->_Username->PlaceHolder = RemoveHtml($this->_Username->caption());

        // Password
        $this->_Password->EditAttrs["class"] = "form-control";
        $this->_Password->EditCustomAttributes = "";
        if (!$this->_Password->Raw) {
            $this->_Password->CurrentValue = HtmlDecode($this->_Password->CurrentValue);
        }
        $this->_Password->EditValue = $this->_Password->CurrentValue;
        $this->_Password->PlaceHolder = RemoveHtml($this->_Password->caption());

        // Userlevel
        $this->_Userlevel->EditAttrs["class"] = "form-control";
        $this->_Userlevel->EditCustomAttributes = "";
        if (!$Security->canAdmin()) { // System admin
            $this->_Userlevel->EditValue = $Language->phrase("PasswordMask");
        } else {
            $this->_Userlevel->EditValue = $this->_Userlevel->options(true);
            $this->_Userlevel->PlaceHolder = RemoveHtml($this->_Userlevel->caption());
        }

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
            $this->MDA_id->CurrentValue = CurrentUserID();
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->EditValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";
        } else {
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
        }

        // session
        $this->__session->EditAttrs["class"] = "form-control";
        $this->__session->EditCustomAttributes = "";
        if (!$this->__session->Raw) {
            $this->__session->CurrentValue = HtmlDecode($this->__session->CurrentValue);
        }
        $this->__session->EditValue = $this->__session->CurrentValue;
        $this->__session->PlaceHolder = RemoveHtml($this->__session->caption());

        // Created_on

        // Updated_on

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->Othername);
                    $doc->exportCaption($this->Status);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Phone_Number);
                    $doc->exportCaption($this->_Username);
                    $doc->exportCaption($this->_Userlevel);
                    $doc->exportCaption($this->MDA_id);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                } else {
                    $doc->exportCaption($this->_userid);
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->Othername);
                    $doc->exportCaption($this->Status);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Phone_Number);
                    $doc->exportCaption($this->_Username);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->Othername);
                        $doc->exportField($this->Status);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Phone_Number);
                        $doc->exportField($this->_Username);
                        $doc->exportField($this->_Userlevel);
                        $doc->exportField($this->MDA_id);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    } else {
                        $doc->exportField($this->_userid);
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->Othername);
                        $doc->exportField($this->Status);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Phone_Number);
                        $doc->exportField($this->_Username);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // User ID filter
    public function getUserIDFilter($userId)
    {
        $userIdFilter = '`MDA_id` = ' . QuotedValue($userId, DATATYPE_NUMBER, Config("USER_TABLE_DBID"));
        return $userIdFilter;
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `reportuserstbl`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Write Audit Trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        $table = 'reportuserstbl';
        $usr = CurrentUserID();
        WriteAuditLog($usr, $typ, $table, "", "", "", "");
    }

    // Write Audit Trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }
        $table = 'reportuserstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['userid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $newvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $newvalue = $rs[$fldname];
                    } else {
                        $newvalue = "[MEMO]"; // Memo Field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $newvalue = "[XML]"; // XML Field
                } else {
                    $newvalue = $rs[$fldname];
                }
                if ($fldname == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                    $newvalue = $Language->phrase("PasswordMask");
                }
                WriteAuditLog($usr, "A", $table, $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write Audit Trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }
        $table = 'reportuserstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['userid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                            $oldvalue = $rsold[$fldname];
                            $newvalue = $rsnew[$fldname];
                        } else {
                            $oldvalue = "[MEMO]";
                            $newvalue = "[MEMO]";
                        }
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    if ($fldname == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    }
                    WriteAuditLog($usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write Audit Trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }
        $table = 'reportuserstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['userid'];

        // Write Audit Trail
        $curUser = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $oldvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $oldvalue = $rs[$fldname];
                    } else {
                        $oldvalue = "[MEMO]"; // Memo field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $oldvalue = "[XML]"; // XML field
                } else {
                    $oldvalue = $rs[$fldname];
                }
                if ($fldname == Config("LOGIN_PASSWORD_FIELD_NAME")) {
                    $oldvalue = $Language->phrase("PasswordMask");
                }
                WriteAuditLog($curUser, "D", $table, $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        // save all fields in a variable
         $Firstname=$rsnew["Firstname"];
          $Othername=$rsnew["Othername"];
           $Lastname=$rsnew["Lastname"];
            $Email =$rsnew["Email"];
             $Phone=$rsnew["Phone_Number"];
              $MDA_id=$rsnew["MDA_id"];
               // Get MDA
    $MDA_temp = ExecuteScalar("SELECT MDA_Acronym FROM mdatbl WHERE MDAID= '$MDA_id'");
              // $MDA_temp=$rsnew["MDA_id"];
                $Asset_User_id=$rsold["userid"];

    // Insert record
    // NOTE: Modify your SQL here, replace the table name, field name and field values
    $sendtodirctory = ExecuteUpdate("INSERT INTO ekdirectory.directorytbl
    (Firstname, Middlename, Lastname,Email,Phone ,MDA_id,MDA_temp,Asset_User_id )
    VALUES ('$Firstname','$Othername', '$Lastname','$Email','$Phone','$MDA_id','$MDA_temp','$Asset_User_id')");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
         // save all fields in a variable
         $Firstname=$rsnew["Firstname"];
          $Othername=$rsnew["Othername"];
           $Lastname=$rsnew["Lastname"];
            $Email =$rsnew["Email"];
             $Phone=$rsnew["Phone_Number"];
              $MDA_id=$rsnew["MDA_id"];
             // Get MDA
    $MDA_temp = ExecuteScalar("SELECT MDA_Acronym FROM mdatbl WHERE MDAID= '$MDA_id'");
              // =$rsnew["MDA_id"];
                $Asset_User_id=$rsold["userid"];

    // Update record
    // NOTE: Modify your SQL here, replace the table name, field name and field values
    $sendtodirctoryPATCH = ExecuteUpdate("UPDATE ekdirectory.directorytbl SET
     Firstname='$Firstname', Middlename='$Othername', Lastname='$Lastname',Email ='$Email',Phone='$Phone',MDA_id='$MDA_id'
     ,MDA_temp='$MDA_temp',Asset_User_id='$Asset_User_id'
     WHERE Email='$Email'");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
