<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for Assetlog
 */
class Assetlog extends ReportTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";
    public $ShowGroupHeaderAsRow = false;
    public $ShowCompactSummaryFooter = true;

    // Export
    public $ExportDoc;

    // Fields
    public $Assetlogid;
    public $Created_on;
    public $Asset_id;
    public $Asset_No;
    public $Details_of_Asset;
    public $Asset_Status;
    public $Condition_Of_Asset;
    public $MDA_id;
    public $Location_id;
    public $Make;
    public $Model;
    public $YearofManufacture;
    public $Colour;
    public $EngineNumber;
    public $ChasisNumber;
    public $CivilianPlateNumber;
    public $GovtPlateNumber;
    public $Custodian_id;
    public $Category;
    public $Category_Details;
    public $Date_of_Acquisition;
    public $Aquistion_Cost;
    public $Additional_Cost;
    public $Revaluation_Cost;
    public $Remarks;
    public $Created_By;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'Assetlog';
        $this->TableName = 'Assetlog';
        $this->TableType = 'REPORT';

        // Update Table
        $this->UpdateTable = "`assetsaudittrailtbl`";
        $this->ReportSourceTable = 'assetsaudittrailtbl'; // Report source table
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (report only)
        $this->ExportPageOrientation = "landscape"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions

        // Assetlogid
        $this->Assetlogid = new ReportField('Assetlog', 'Assetlog', 'x_Assetlogid', 'Assetlogid', '`Assetlogid`', '`Assetlogid`', 3, 11, -1, false, '`Assetlogid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->Assetlogid->IsAutoIncrement = true; // Autoincrement field
        $this->Assetlogid->IsPrimaryKey = true; // Primary key field
        $this->Assetlogid->Sortable = true; // Allow sort
        $this->Assetlogid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Assetlogid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Assetlogid->Param, "CustomMsg");
        $this->Assetlogid->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Assetlogid'] = &$this->Assetlogid;

        // Created_on
        $this->Created_on = new ReportField('Assetlog', 'Assetlog', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 11, "DB"), 135, 19, 11, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Created_on->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Created_on'] = &$this->Created_on;

        // Asset_id
        $this->Asset_id = new ReportField('Assetlog', 'Assetlog', 'x_Asset_id', 'Asset_id', '`Asset_id`', '`Asset_id`', 3, 100, -1, false, '`Asset_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_id->Nullable = false; // NOT NULL field
        $this->Asset_id->Required = true; // Required field
        $this->Asset_id->Sortable = true; // Allow sort
        $this->Asset_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Asset_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_id->Param, "CustomMsg");
        $this->Asset_id->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Asset_id'] = &$this->Asset_id;

        // Asset_No
        $this->Asset_No = new ReportField('Assetlog', 'Assetlog', 'x_Asset_No', 'Asset_No', '`Asset_No`', '`Asset_No`', 200, 255, -1, false, '`Asset_No`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_No->Sortable = true; // Allow sort
        $this->Asset_No->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_No->Param, "CustomMsg");
        $this->Asset_No->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Asset_No'] = &$this->Asset_No;

        // Details_of_Asset
        $this->Details_of_Asset = new ReportField('Assetlog', 'Assetlog', 'x_Details_of_Asset', 'Details_of_Asset', '`Details_of_Asset`', '`Details_of_Asset`', 200, 255, -1, false, '`Details_of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Details_of_Asset->Nullable = false; // NOT NULL field
        $this->Details_of_Asset->Required = true; // Required field
        $this->Details_of_Asset->Sortable = true; // Allow sort
        $this->Details_of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Details_of_Asset->Param, "CustomMsg");
        $this->Details_of_Asset->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Details_of_Asset'] = &$this->Details_of_Asset;

        // Asset_Status
        $this->Asset_Status = new ReportField('Assetlog', 'Assetlog', 'x_Asset_Status', 'Asset_Status', '`Asset_Status`', '`Asset_Status`', 200, 255, -1, false, '`Asset_Status`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_Status->Nullable = false; // NOT NULL field
        $this->Asset_Status->Sortable = true; // Allow sort
        $this->Asset_Status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_Status->Param, "CustomMsg");
        $this->Asset_Status->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Asset_Status'] = &$this->Asset_Status;

        // Condition_Of_Asset
        $this->Condition_Of_Asset = new ReportField('Assetlog', 'Assetlog', 'x_Condition_Of_Asset', 'Condition_Of_Asset', '`Condition_Of_Asset`', '`Condition_Of_Asset`', 200, 255, -1, false, '`Condition_Of_Asset`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Condition_Of_Asset->Nullable = false; // NOT NULL field
        $this->Condition_Of_Asset->Sortable = true; // Allow sort
        $this->Condition_Of_Asset->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Condition_Of_Asset->Param, "CustomMsg");
        $this->Condition_Of_Asset->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Condition_Of_Asset'] = &$this->Condition_Of_Asset;

        // MDA_id
        $this->MDA_id = new ReportField('Assetlog', 'Assetlog', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], [], ["x_Location_id"], [], [], [], [], '`MDA_Acronym`', '');
                break;
            default:
                $this->MDA_id->Lookup = new Lookup('MDA_id', 'mdatbl', true, 'MDAID', ["MDA_Acronym","","",""], [], ["x_Location_id"], [], [], [], [], '`MDA_Acronym`', '');
                break;
        }
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->MDA_id->AdvancedSearch->SearchValueDefault = INIT_VALUE;
        $this->MDA_id->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Location_id
        $this->Location_id = new ReportField('Assetlog', 'Assetlog', 'x_Location_id', 'Location_id', '`Location_id`', '`Location_id`', 3, 100, -1, false, '`Location_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Location_id->Nullable = false; // NOT NULL field
        $this->Location_id->Required = true; // Required field
        $this->Location_id->Sortable = true; // Allow sort
        $this->Location_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Location_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
            default:
                $this->Location_id->Lookup = new Lookup('Location_id', 'locationtbl', true, 'Locationid', ["Location","","",""], ["x_MDA_id"], [], ["MDA_id"], ["x_MDA_id"], [], [], '`Location`', '');
                break;
        }
        $this->Location_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Location_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Location_id->Param, "CustomMsg");
        $this->Location_id->AdvancedSearch->SearchValueDefault = INIT_VALUE;
        $this->Location_id->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Location_id'] = &$this->Location_id;

        // Make
        $this->Make = new ReportField('Assetlog', 'Assetlog', 'x_Make', 'Make', '`Make`', '`Make`', 200, 100, -1, false, '`Make`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Make->Sortable = true; // Allow sort
        $this->Make->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Make->Param, "CustomMsg");
        $this->Make->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Make'] = &$this->Make;

        // Model
        $this->Model = new ReportField('Assetlog', 'Assetlog', 'x_Model', 'Model', '`Model`', '`Model`', 200, 100, -1, false, '`Model`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Model->Sortable = true; // Allow sort
        $this->Model->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Model->Param, "CustomMsg");
        $this->Model->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Model'] = &$this->Model;

        // Year of Manufacture
        $this->YearofManufacture = new ReportField('Assetlog', 'Assetlog', 'x_YearofManufacture', 'Year of Manufacture', '`Year of Manufacture`', '`Year of Manufacture`', 3, 4, -1, false, '`Year of Manufacture`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->YearofManufacture->Sortable = true; // Allow sort
        $this->YearofManufacture->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->YearofManufacture->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->YearofManufacture->Param, "CustomMsg");
        $this->YearofManufacture->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Year of Manufacture'] = &$this->YearofManufacture;

        // Colour
        $this->Colour = new ReportField('Assetlog', 'Assetlog', 'x_Colour', 'Colour', '`Colour`', '`Colour`', 200, 50, -1, false, '`Colour`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Colour->Sortable = true; // Allow sort
        $this->Colour->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Colour->Param, "CustomMsg");
        $this->Colour->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Colour'] = &$this->Colour;

        // Engine Number
        $this->EngineNumber = new ReportField('Assetlog', 'Assetlog', 'x_EngineNumber', 'Engine Number', '`Engine Number`', '`Engine Number`', 200, 100, -1, false, '`Engine Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->EngineNumber->Sortable = true; // Allow sort
        $this->EngineNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->EngineNumber->Param, "CustomMsg");
        $this->EngineNumber->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Engine Number'] = &$this->EngineNumber;

        // Chasis Number
        $this->ChasisNumber = new ReportField('Assetlog', 'Assetlog', 'x_ChasisNumber', 'Chasis Number', '`Chasis Number`', '`Chasis Number`', 200, 100, -1, false, '`Chasis Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->ChasisNumber->Sortable = true; // Allow sort
        $this->ChasisNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->ChasisNumber->Param, "CustomMsg");
        $this->ChasisNumber->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Chasis Number'] = &$this->ChasisNumber;

        // Civilian Plate Number
        $this->CivilianPlateNumber = new ReportField('Assetlog', 'Assetlog', 'x_CivilianPlateNumber', 'Civilian Plate Number', '`Civilian Plate Number`', '`Civilian Plate Number`', 200, 20, -1, false, '`Civilian Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->CivilianPlateNumber->Sortable = true; // Allow sort
        $this->CivilianPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->CivilianPlateNumber->Param, "CustomMsg");
        $this->CivilianPlateNumber->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Civilian Plate Number'] = &$this->CivilianPlateNumber;

        // Govt Plate Number
        $this->GovtPlateNumber = new ReportField('Assetlog', 'Assetlog', 'x_GovtPlateNumber', 'Govt Plate Number', '`Govt Plate Number`', '`Govt Plate Number`', 200, 20, -1, false, '`Govt Plate Number`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->GovtPlateNumber->Sortable = true; // Allow sort
        $this->GovtPlateNumber->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->GovtPlateNumber->Param, "CustomMsg");
        $this->GovtPlateNumber->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Govt Plate Number'] = &$this->GovtPlateNumber;

        // Custodian_id
        $this->Custodian_id = new ReportField('Assetlog', 'Assetlog', 'x_Custodian_id', 'Custodian_id', '`Custodian_id`', '`Custodian_id`', 3, 100, -1, false, '`Custodian_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Custodian_id->Nullable = false; // NOT NULL field
        $this->Custodian_id->Required = true; // Required field
        $this->Custodian_id->Sortable = true; // Allow sort
        $this->Custodian_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Custodian_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', true, 'id', ["Lastname","Firstname","",""], [], [], [], [], [], [], '`Lastname`', '');
                break;
            default:
                $this->Custodian_id->Lookup = new Lookup('Custodian_id', 'custodianstbl', true, 'id', ["Lastname","Firstname","",""], [], [], [], [], [], [], '`Lastname`', '');
                break;
        }
        $this->Custodian_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Custodian_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Custodian_id->Param, "CustomMsg");
        $this->Custodian_id->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Custodian_id'] = &$this->Custodian_id;

        // Category
        $this->Category = new ReportField('Assetlog', 'Assetlog', 'x_Category', 'Category', '`Category`', '`Category`', 3, 20, -1, false, '`Category`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Category->Nullable = false; // NOT NULL field
        $this->Category->Required = true; // Required field
        $this->Category->Sortable = true; // Allow sort
        $this->Category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', true, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '`Category`', '');
                break;
            default:
                $this->Category->Lookup = new Lookup('Category', 'categorytbl', true, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '`Category`', '');
                break;
        }
        $this->Category->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category->Param, "CustomMsg");
        $this->Category->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Category'] = &$this->Category;

        // Category_Details
        $this->Category_Details = new ReportField('Assetlog', 'Assetlog', 'x_Category_Details', 'Category_Details', '`Category_Details`', '`Category_Details`', 200, 255, -1, false, '`Category_Details`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Category_Details->Sortable = true; // Allow sort
        $this->Category_Details->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Details->Param, "CustomMsg");
        $this->Category_Details->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Category_Details'] = &$this->Category_Details;

        // Date_of_Acquisition
        $this->Date_of_Acquisition = new ReportField('Assetlog', 'Assetlog', 'x_Date_of_Acquisition', 'Date_of_Acquisition', '`Date_of_Acquisition`', CastDateFieldForLike("`Date_of_Acquisition`", 0, "DB"), 133, 10, 0, false, '`Date_of_Acquisition`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Date_of_Acquisition->Nullable = false; // NOT NULL field
        $this->Date_of_Acquisition->Required = true; // Required field
        $this->Date_of_Acquisition->Sortable = true; // Allow sort
        $this->Date_of_Acquisition->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Date_of_Acquisition->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Date_of_Acquisition->Param, "CustomMsg");
        $this->Date_of_Acquisition->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Date_of_Acquisition'] = &$this->Date_of_Acquisition;

        // Aquistion_Cost
        $this->Aquistion_Cost = new ReportField('Assetlog', 'Assetlog', 'x_Aquistion_Cost', 'Aquistion_Cost', '`Aquistion_Cost`', '`Aquistion_Cost`', 5, 22, -1, false, '`Aquistion_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Aquistion_Cost->Nullable = false; // NOT NULL field
        $this->Aquistion_Cost->Required = true; // Required field
        $this->Aquistion_Cost->Sortable = true; // Allow sort
        $this->Aquistion_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Aquistion_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Aquistion_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Aquistion_Cost->Param, "CustomMsg");
        $this->Aquistion_Cost->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Aquistion_Cost'] = &$this->Aquistion_Cost;

        // Additional_Cost
        $this->Additional_Cost = new ReportField('Assetlog', 'Assetlog', 'x_Additional_Cost', 'Additional_Cost', '`Additional_Cost`', '`Additional_Cost`', 5, 22, -1, false, '`Additional_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Additional_Cost->Sortable = true; // Allow sort
        $this->Additional_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Additional_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Additional_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Additional_Cost->Param, "CustomMsg");
        $this->Additional_Cost->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Additional_Cost'] = &$this->Additional_Cost;

        // Revaluation_Cost
        $this->Revaluation_Cost = new ReportField('Assetlog', 'Assetlog', 'x_Revaluation_Cost', 'Revaluation_Cost', '`Revaluation_Cost`', '`Revaluation_Cost`', 5, 22, -1, false, '`Revaluation_Cost`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Revaluation_Cost->Sortable = true; // Allow sort
        $this->Revaluation_Cost->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Revaluation_Cost->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Revaluation_Cost->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Revaluation_Cost->Param, "CustomMsg");
        $this->Revaluation_Cost->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Revaluation_Cost'] = &$this->Revaluation_Cost;

        // Remarks
        $this->Remarks = new ReportField('Assetlog', 'Assetlog', 'x_Remarks', 'Remarks', '`Remarks`', '`Remarks`', 201, -1, -1, false, '`Remarks`', false, false, false, 'FORMATTED TEXT', 'TEXTAREA');
        $this->Remarks->Sortable = true; // Allow sort
        $this->Remarks->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Remarks->Param, "CustomMsg");
        $this->Remarks->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Remarks'] = &$this->Remarks;

        // Created_By
        $this->Created_By = new ReportField('Assetlog', 'Assetlog', 'x_Created_By', 'Created_By', '`Created_By`', '`Created_By`', 3, 11, -1, false, '`Created_By`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Created_By->Sortable = true; // Allow sort
        $this->Created_By->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Created_By->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Created_By->Lookup = new Lookup('Created_By', 'reportuserstbl', false, 'userid', ["Lastname","Firstname","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->Created_By->Lookup = new Lookup('Created_By', 'reportuserstbl', false, 'userid', ["Lastname","Firstname","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->Created_By->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Created_By->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_By->Param, "CustomMsg");
        $this->Created_By->AdvancedSearch->SearchValueDefault = INIT_VALUE;
        $this->Created_By->SourceTableVar = 'assetsaudittrailtbl';
        $this->Fields['Created_By'] = &$this->Created_By;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Single column sort
    protected function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($fld->GroupingFieldId == 0) {
                $this->setDetailOrderBy($curOrderBy); // Save to Session
            }
        } else {
            if ($fld->GroupingFieldId == 0) {
                $fld->setSort("");
            }
        }
    }

    // Get Sort SQL
    protected function sortSql()
    {
        $dtlSortSql = $this->getDetailOrderBy(); // Get ORDER BY for detail fields from session
        $argrps = [];
        foreach ($this->Fields as $fld) {
            if (in_array($fld->getSort(), ["ASC", "DESC"])) {
                $fldsql = $fld->Expression;
                if ($fld->GroupingFieldId > 0) {
                    if ($fld->GroupSql != "") {
                        $argrps[$fld->GroupingFieldId] = str_replace("%s", $fldsql, $fld->GroupSql) . " " . $fld->getSort();
                    } else {
                        $argrps[$fld->GroupingFieldId] = $fldsql . " " . $fld->getSort();
                    }
                }
            }
        }
        $sortSql = "";
        foreach ($argrps as $grp) {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $grp;
        }
        if ($dtlSortSql != "") {
            if ($sortSql != "") {
                $sortSql .= ", ";
            }
            $sortSql .= $dtlSortSql;
        }
        return $sortSql;
    }

    // Summary properties
    private $sqlSelectAggregate = null;
    private $sqlAggregatePrefix = "";
    private $sqlAggregateSuffix = "";
    private $sqlSelectCount = null;

    // Select Aggregate
    public function getSqlSelectAggregate()
    {
        return $this->sqlSelectAggregate ?? $this->getQueryBuilder()->select("SUM(`Aquistion_Cost`) AS `sum_aquistion_cost`, SUM(`Additional_Cost`) AS `sum_additional_cost`, SUM(`Revaluation_Cost`) AS `sum_revaluation_cost`");
    }

    public function setSqlSelectAggregate($v)
    {
        $this->sqlSelectAggregate = $v;
    }

    // Aggregate Prefix
    public function getSqlAggregatePrefix()
    {
        return ($this->sqlAggregatePrefix != "") ? $this->sqlAggregatePrefix : "";
    }

    public function setSqlAggregatePrefix($v)
    {
        $this->sqlAggregatePrefix = $v;
    }

    // Aggregate Suffix
    public function getSqlAggregateSuffix()
    {
        return ($this->sqlAggregateSuffix != "") ? $this->sqlAggregateSuffix : "";
    }

    public function setSqlAggregateSuffix($v)
    {
        $this->sqlAggregateSuffix = $v;
    }

    // Select Count
    public function getSqlSelectCount()
    {
        return $this->sqlSelectCount ?? $this->getQueryBuilder()->select("COUNT(*)");
    }

    public function setSqlSelectCount($v)
    {
        $this->sqlSelectCount = $v;
    }

    // Render for lookup
    public function renderLookup()
    {
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->CurrentValue, 11);
        $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
        $this->MDA_id->ViewValue = GetDropDownDisplayValue($this->MDA_id->CurrentValue, "", 0);
        $this->Location_id->ViewValue = GetDropDownDisplayValue($this->Location_id->CurrentValue, "", 0);
        $this->Created_By->ViewValue = GetDropDownDisplayValue($this->Created_By->CurrentValue, "", 0);
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`assetsaudittrailtbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        if ($this->SqlSelect) {
            return $this->SqlSelect;
        }
        $select = $this->getQueryBuilder()->select("*");
        return $select;
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Assetlogid` = @Assetlogid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Assetlogid->CurrentValue : $this->Assetlogid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Assetlogid->CurrentValue = $keys[0];
            } else {
                $this->Assetlogid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Assetlogid', $row) ? $row['Assetlogid'] : null;
        } else {
            $val = $this->Assetlogid->OldValue !== null ? $this->Assetlogid->OldValue : $this->Assetlogid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Assetlogid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "") {
            return $Language->phrase("View");
        } elseif ($pageName == "") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "";
            case Config("API_ADD_ACTION"):
                return "";
            case Config("API_EDIT_ACTION"):
                return "";
            case Config("API_DELETE_ACTION"):
                return "";
            case Config("API_LIST_ACTION"):
                return "";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "?" . $this->getUrlParm($parm);
        } else {
            $url = "";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "Assetlogid:" . JsonEncode($this->Assetlogid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Assetlogid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->Assetlogid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            $this->DrillDown || $DashboardReport ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Assetlogid") ?? Route("Assetlogid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Assetlogid->CurrentValue = $key;
            } else {
                $this->Assetlogid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `assetsaudittrailtbl`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
