<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for categorydetailstbl
 */
class Categorydetailstbl extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Export
    public $ExportDoc;

    // Fields
    public $Categorydetailsid;
    public $Category_id;
    public $Category_Abrivation;
    public $Category_Details;
    public $Depreciation_Rate;
    public $Expert_Valuation_Multiplier;
    public $Created_on;
    public $Updated_on;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'categorydetailstbl';
        $this->TableName = 'categorydetailstbl';
        $this->TableType = 'TABLE';

        // Update Table
        $this->UpdateTable = "`categorydetailstbl`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = 50; // Cell width (PHPWord only)
        $this->DetailAdd = true; // Allow detail add
        $this->DetailEdit = true; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // Categorydetailsid
        $this->Categorydetailsid = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Categorydetailsid', 'Categorydetailsid', '`Categorydetailsid`', '`Categorydetailsid`', 3, 11, -1, false, '`Categorydetailsid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->Categorydetailsid->IsAutoIncrement = true; // Autoincrement field
        $this->Categorydetailsid->IsPrimaryKey = true; // Primary key field
        $this->Categorydetailsid->IsForeignKey = true; // Foreign key field
        $this->Categorydetailsid->Sortable = true; // Allow sort
        $this->Categorydetailsid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Categorydetailsid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Categorydetailsid->Param, "CustomMsg");
        $this->Fields['Categorydetailsid'] = &$this->Categorydetailsid;

        // Category_id
        $this->Category_id = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Category_id', 'Category_id', '`Category_id`', '`Category_id`', 3, 11, -1, false, '`Category_id`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->Category_id->Nullable = false; // NOT NULL field
        $this->Category_id->Required = true; // Required field
        $this->Category_id->Sortable = true; // Allow sort
        $this->Category_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Category_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->Category_id->Lookup = new Lookup('Category_id', 'categorytbl', false, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->Category_id->Lookup = new Lookup('Category_id', 'categorytbl', false, 'Categoryid', ["Category","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->Category_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Category_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_id->Param, "CustomMsg");
        $this->Fields['Category_id'] = &$this->Category_id;

        // Category_Abrivation
        $this->Category_Abrivation = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Category_Abrivation', 'Category_Abrivation', '`Category_Abrivation`', '`Category_Abrivation`', 200, 100, -1, false, '`Category_Abrivation`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Category_Abrivation->Sortable = true; // Allow sort
        $this->Category_Abrivation->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Abrivation->Param, "CustomMsg");
        $this->Fields['Category_Abrivation'] = &$this->Category_Abrivation;

        // Category_Details
        $this->Category_Details = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Category_Details', 'Category_Details', '`Category_Details`', '`Category_Details`', 200, 255, -1, false, '`Category_Details`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Category_Details->Nullable = false; // NOT NULL field
        $this->Category_Details->Required = true; // Required field
        $this->Category_Details->Sortable = true; // Allow sort
        $this->Category_Details->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Category_Details->Param, "CustomMsg");
        $this->Fields['Category_Details'] = &$this->Category_Details;

        // Depreciation_Rate
        $this->Depreciation_Rate = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Depreciation_Rate', 'Depreciation_Rate', '`Depreciation_Rate`', '`Depreciation_Rate`', 131, 10, -1, false, '`Depreciation_Rate`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Depreciation_Rate->Nullable = false; // NOT NULL field
        $this->Depreciation_Rate->Sortable = true; // Allow sort
        $this->Depreciation_Rate->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Depreciation_Rate->DefaultErrorMessage = str_replace(["%1", "%2"], ["0.00", "100.00"], $Language->phrase("IncorrectRange"));
        $this->Depreciation_Rate->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Depreciation_Rate->Param, "CustomMsg");
        $this->Fields['Depreciation_Rate'] = &$this->Depreciation_Rate;

        // Expert_Valuation_Multiplier
        $this->Expert_Valuation_Multiplier = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Expert_Valuation_Multiplier', 'Expert_Valuation_Multiplier', '`Expert_Valuation_Multiplier`', '`Expert_Valuation_Multiplier`', 131, 10, -1, false, '`Expert_Valuation_Multiplier`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Expert_Valuation_Multiplier->Nullable = false; // NOT NULL field
        $this->Expert_Valuation_Multiplier->Sortable = true; // Allow sort
        $this->Expert_Valuation_Multiplier->DefaultDecimalPrecision = 2; // Default decimal precision
        $this->Expert_Valuation_Multiplier->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Expert_Valuation_Multiplier->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Expert_Valuation_Multiplier->Param, "CustomMsg");
        $this->Fields['Expert_Valuation_Multiplier'] = &$this->Expert_Valuation_Multiplier;

        // Created_on
        $this->Created_on = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "DB"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('categorydetailstbl', 'categorydetailstbl', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "DB"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE"));
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "assetconditionvaluationtbl") {
            $detailUrl = Container("assetconditionvaluationtbl")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_Categorydetailsid", $this->Categorydetailsid->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "categorydetailstbllist";
        }
        return $detailUrl;
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`categorydetailstbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->Categorydetailsid->setDbValue($conn->lastInsertId());
            $rs['Categorydetailsid'] = $this->Categorydetailsid->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'Categorydetailsid';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Categorydetailsid', $rs)) {
                AddFilter($where, QuotedName('Categorydetailsid', $this->Dbid) . '=' . QuotedValue($rs['Categorydetailsid'], $this->Categorydetailsid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Categorydetailsid->DbValue = $row['Categorydetailsid'];
        $this->Category_id->DbValue = $row['Category_id'];
        $this->Category_Abrivation->DbValue = $row['Category_Abrivation'];
        $this->Category_Details->DbValue = $row['Category_Details'];
        $this->Depreciation_Rate->DbValue = $row['Depreciation_Rate'];
        $this->Expert_Valuation_Multiplier->DbValue = $row['Expert_Valuation_Multiplier'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Categorydetailsid` = @Categorydetailsid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Categorydetailsid->CurrentValue : $this->Categorydetailsid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Categorydetailsid->CurrentValue = $keys[0];
            } else {
                $this->Categorydetailsid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Categorydetailsid', $row) ? $row['Categorydetailsid'] : null;
        } else {
            $val = $this->Categorydetailsid->OldValue !== null ? $this->Categorydetailsid->OldValue : $this->Categorydetailsid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Categorydetailsid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("categorydetailstbllist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "categorydetailstblview") {
            return $Language->phrase("View");
        } elseif ($pageName == "categorydetailstbledit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "categorydetailstbladd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "CategorydetailstblView";
            case Config("API_ADD_ACTION"):
                return "CategorydetailstblAdd";
            case Config("API_EDIT_ACTION"):
                return "CategorydetailstblEdit";
            case Config("API_DELETE_ACTION"):
                return "CategorydetailstblDelete";
            case Config("API_LIST_ACTION"):
                return "CategorydetailstblList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "categorydetailstbllist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("categorydetailstblview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("categorydetailstblview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "categorydetailstbladd?" . $this->getUrlParm($parm);
        } else {
            $url = "categorydetailstbladd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("categorydetailstbledit", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("categorydetailstbledit", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("categorydetailstbladd", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("categorydetailstbladd", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("categorydetailstbldelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "Categorydetailsid:" . JsonEncode($this->Categorydetailsid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Categorydetailsid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->Categorydetailsid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Categorydetailsid") ?? Route("Categorydetailsid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Categorydetailsid->CurrentValue = $key;
            } else {
                $this->Categorydetailsid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Categorydetailsid->setDbValue($row['Categorydetailsid']);
        $this->Category_id->setDbValue($row['Category_id']);
        $this->Category_Abrivation->setDbValue($row['Category_Abrivation']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Depreciation_Rate->setDbValue($row['Depreciation_Rate']);
        $this->Expert_Valuation_Multiplier->setDbValue($row['Expert_Valuation_Multiplier']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Categorydetailsid

        // Category_id

        // Category_Abrivation

        // Category_Details

        // Depreciation_Rate

        // Expert_Valuation_Multiplier

        // Created_on

        // Updated_on

        // Categorydetailsid
        $this->Categorydetailsid->ViewValue = $this->Categorydetailsid->CurrentValue;
        $this->Categorydetailsid->ViewCustomAttributes = "";

        // Category_id
        $curVal = trim(strval($this->Category_id->CurrentValue));
        if ($curVal != "") {
            $this->Category_id->ViewValue = $this->Category_id->lookupCacheOption($curVal);
            if ($this->Category_id->ViewValue === null) { // Lookup from database
                $filterWrk = "`Categoryid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->Category_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Category_id->Lookup->renderViewRow($rswrk[0]);
                    $this->Category_id->ViewValue = $this->Category_id->displayValue($arwrk);
                } else {
                    $this->Category_id->ViewValue = $this->Category_id->CurrentValue;
                }
            }
        } else {
            $this->Category_id->ViewValue = null;
        }
        $this->Category_id->ViewCustomAttributes = "";

        // Category_Abrivation
        $this->Category_Abrivation->ViewValue = $this->Category_Abrivation->CurrentValue;
        $this->Category_Abrivation->ViewCustomAttributes = "";

        // Category_Details
        $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
        $this->Category_Details->ViewCustomAttributes = "";

        // Depreciation_Rate
        $this->Depreciation_Rate->ViewValue = $this->Depreciation_Rate->CurrentValue;
        $this->Depreciation_Rate->ViewValue = FormatNumber($this->Depreciation_Rate->ViewValue, 2, -2, -2, -2);
        $this->Depreciation_Rate->ViewCustomAttributes = "";

        // Expert_Valuation_Multiplier
        $this->Expert_Valuation_Multiplier->ViewValue = $this->Expert_Valuation_Multiplier->CurrentValue;
        $this->Expert_Valuation_Multiplier->ViewValue = FormatNumber($this->Expert_Valuation_Multiplier->ViewValue, 2, -2, -2, -2);
        $this->Expert_Valuation_Multiplier->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // Categorydetailsid
        $this->Categorydetailsid->LinkCustomAttributes = "";
        $this->Categorydetailsid->HrefValue = "";
        $this->Categorydetailsid->TooltipValue = "";

        // Category_id
        $this->Category_id->LinkCustomAttributes = "";
        $this->Category_id->HrefValue = "";
        $this->Category_id->TooltipValue = "";

        // Category_Abrivation
        $this->Category_Abrivation->LinkCustomAttributes = "";
        $this->Category_Abrivation->HrefValue = "";
        $this->Category_Abrivation->TooltipValue = "";

        // Category_Details
        $this->Category_Details->LinkCustomAttributes = "";
        $this->Category_Details->HrefValue = "";
        $this->Category_Details->TooltipValue = "";

        // Depreciation_Rate
        $this->Depreciation_Rate->LinkCustomAttributes = "";
        $this->Depreciation_Rate->HrefValue = "";
        $this->Depreciation_Rate->TooltipValue = "";

        // Expert_Valuation_Multiplier
        $this->Expert_Valuation_Multiplier->LinkCustomAttributes = "";
        $this->Expert_Valuation_Multiplier->HrefValue = "";
        $this->Expert_Valuation_Multiplier->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Categorydetailsid
        $this->Categorydetailsid->EditAttrs["class"] = "form-control";
        $this->Categorydetailsid->EditCustomAttributes = "";
        $this->Categorydetailsid->EditValue = $this->Categorydetailsid->CurrentValue;
        $this->Categorydetailsid->ViewCustomAttributes = "";

        // Category_id
        $this->Category_id->EditAttrs["class"] = "form-control";
        $this->Category_id->EditCustomAttributes = "";
        $this->Category_id->PlaceHolder = RemoveHtml($this->Category_id->caption());

        // Category_Abrivation
        $this->Category_Abrivation->EditAttrs["class"] = "form-control";
        $this->Category_Abrivation->EditCustomAttributes = "";
        if (!$this->Category_Abrivation->Raw) {
            $this->Category_Abrivation->CurrentValue = HtmlDecode($this->Category_Abrivation->CurrentValue);
        }
        $this->Category_Abrivation->EditValue = $this->Category_Abrivation->CurrentValue;
        $this->Category_Abrivation->PlaceHolder = RemoveHtml($this->Category_Abrivation->caption());

        // Category_Details
        $this->Category_Details->EditAttrs["class"] = "form-control";
        $this->Category_Details->EditCustomAttributes = "";
        if (!$this->Category_Details->Raw) {
            $this->Category_Details->CurrentValue = HtmlDecode($this->Category_Details->CurrentValue);
        }
        $this->Category_Details->EditValue = $this->Category_Details->CurrentValue;
        $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

        // Depreciation_Rate
        $this->Depreciation_Rate->EditAttrs["class"] = "form-control";
        $this->Depreciation_Rate->EditCustomAttributes = "";
        $this->Depreciation_Rate->EditValue = $this->Depreciation_Rate->CurrentValue;
        $this->Depreciation_Rate->PlaceHolder = RemoveHtml($this->Depreciation_Rate->caption());
        if (strval($this->Depreciation_Rate->EditValue) != "" && is_numeric($this->Depreciation_Rate->EditValue)) {
            $this->Depreciation_Rate->EditValue = FormatNumber($this->Depreciation_Rate->EditValue, -2, -2, -2, -2);
        }

        // Expert_Valuation_Multiplier
        $this->Expert_Valuation_Multiplier->EditAttrs["class"] = "form-control";
        $this->Expert_Valuation_Multiplier->EditCustomAttributes = "";
        $this->Expert_Valuation_Multiplier->EditValue = $this->Expert_Valuation_Multiplier->CurrentValue;
        $this->Expert_Valuation_Multiplier->PlaceHolder = RemoveHtml($this->Expert_Valuation_Multiplier->caption());
        if (strval($this->Expert_Valuation_Multiplier->EditValue) != "" && is_numeric($this->Expert_Valuation_Multiplier->EditValue)) {
            $this->Expert_Valuation_Multiplier->EditValue = FormatNumber($this->Expert_Valuation_Multiplier->EditValue, -2, -2, -2, -2);
        }

        // Created_on

        // Updated_on

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Categorydetailsid);
                    $doc->exportCaption($this->Category_id);
                    $doc->exportCaption($this->Category_Abrivation);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Depreciation_Rate);
                    $doc->exportCaption($this->Expert_Valuation_Multiplier);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Updated_on);
                } else {
                    $doc->exportCaption($this->Categorydetailsid);
                    $doc->exportCaption($this->Category_id);
                    $doc->exportCaption($this->Category_Abrivation);
                    $doc->exportCaption($this->Category_Details);
                    $doc->exportCaption($this->Depreciation_Rate);
                    $doc->exportCaption($this->Expert_Valuation_Multiplier);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Categorydetailsid);
                        $doc->exportField($this->Category_id);
                        $doc->exportField($this->Category_Abrivation);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Depreciation_Rate);
                        $doc->exportField($this->Expert_Valuation_Multiplier);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Updated_on);
                    } else {
                        $doc->exportField($this->Categorydetailsid);
                        $doc->exportField($this->Category_id);
                        $doc->exportField($this->Category_Abrivation);
                        $doc->exportField($this->Category_Details);
                        $doc->exportField($this->Depreciation_Rate);
                        $doc->exportField($this->Expert_Valuation_Multiplier);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Write Audit Trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        $table = 'categorydetailstbl';
        $usr = CurrentUserID();
        WriteAuditLog($usr, $typ, $table, "", "", "", "");
    }

    // Write Audit Trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }
        $table = 'categorydetailstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['Categorydetailsid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $newvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $newvalue = $rs[$fldname];
                    } else {
                        $newvalue = "[MEMO]"; // Memo Field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $newvalue = "[XML]"; // XML Field
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", $table, $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write Audit Trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }
        $table = 'categorydetailstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['Categorydetailsid'];

        // Write Audit Trail
        $usr = CurrentUserID();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
                        if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                            $oldvalue = $rsold[$fldname];
                            $newvalue = $rsnew[$fldname];
                        } else {
                            $oldvalue = "[MEMO]";
                            $newvalue = "[MEMO]";
                        }
                    } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write Audit Trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }
        $table = 'categorydetailstbl';

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['Categorydetailsid'];

        // Write Audit Trail
        $curUser = CurrentUserID();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DATATYPE_BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") {
                    $oldvalue = $Language->phrase("PasswordMask"); // Password Field
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_MEMO) {
                    if (Config("AUDIT_TRAIL_TO_DATABASE")) {
                        $oldvalue = $rs[$fldname];
                    } else {
                        $oldvalue = "[MEMO]"; // Memo field
                    }
                } elseif ($this->Fields[$fldname]->DataType == DATATYPE_XML) {
                    $oldvalue = "[XML]"; // XML field
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($curUser, "D", $table, $fldname, $key, $oldvalue, "");
            }
        }
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
