<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Page class
 */
class VerifyassetsList extends Verifyassets
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Table name
    public $TableName = 'verify assets';

    // Page object name
    public $PageObjName = "VerifyassetsList";

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fverifyassetslist";
    public $FormActionName = "k_action";
    public $FormBlankRowName = "k_blankrow";
    public $FormKeyCountName = "key_count";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $CopyUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $ListUrl;

    // Export URLs
    public $ExportPrintUrl;
    public $ExportHtmlUrl;
    public $ExportExcelUrl;
    public $ExportWordUrl;
    public $ExportXmlUrl;
    public $ExportCsvUrl;
    public $ExportPdfUrl;

    // Custom export
    public $ExportExcelCustom = false;
    public $ExportWordCustom = false;
    public $ExportPdfCustom = false;
    public $ExportEmailCustom = false;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl()
    {
        $url = ScriptName() . "?";
        if ($this->UseTokenInUrl) {
            $url .= "t=" . $this->TableVar . "&"; // Add page token
        }
        return $url;
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<p id="ew-page-header">' . $header . '</p>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<p id="ew-page-footer">' . $footer . '</p>';
        }
    }

    // Validate page request
    protected function isPageRequest()
    {
        global $CurrentForm;
        if ($this->UseTokenInUrl) {
            if ($CurrentForm) {
                return ($this->TableVar == $CurrentForm->getValue("t"));
            }
            if (Get("t") !== null) {
                return ($this->TableVar == Get("t"));
            }
        }
        return true;
    }

    // Constructor
    public function __construct()
    {
        global $Language, $DashboardReport, $DebugTimer;
        global $UserTable;

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("language");

        // Parent constuctor
        parent::__construct();

        // Table object (verifyassets)
        if (!isset($GLOBALS["verifyassets"]) || get_class($GLOBALS["verifyassets"]) == PROJECT_NAMESPACE . "verifyassets") {
            $GLOBALS["verifyassets"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl();

        // Initialize URLs
        $this->ExportPrintUrl = $pageUrl . "export=print";
        $this->ExportExcelUrl = $pageUrl . "export=excel";
        $this->ExportWordUrl = $pageUrl . "export=word";
        $this->ExportPdfUrl = $pageUrl . "export=pdf";
        $this->ExportHtmlUrl = $pageUrl . "export=html";
        $this->ExportXmlUrl = $pageUrl . "export=xml";
        $this->ExportCsvUrl = $pageUrl . "export=csv";
        $this->AddUrl = "verifyassetsadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiDeleteUrl = "verifyassetsdelete";
        $this->MultiUpdateUrl = "verifyassetsupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'verify assets');
        }

        // Start timer
        $DebugTimer = Container("timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] = $GLOBALS["Conn"] ?? $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions();
        $this->ListOptions->TableVar = $this->TableVar;

        // Export options
        $this->ExportOptions = new ListOptions("div");
        $this->ExportOptions->TagClassName = "ew-export-option";

        // Import options
        $this->ImportOptions = new ListOptions("div");
        $this->ImportOptions->TagClassName = "ew-import-option";

        // Other options
        if (!$this->OtherOptions) {
            $this->OtherOptions = new ListOptionsArray();
        }
        $this->OtherOptions["addedit"] = new ListOptions("div");
        $this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
        $this->OtherOptions["detail"] = new ListOptions("div");
        $this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
        $this->OtherOptions["action"] = new ListOptions("div");
        $this->OtherOptions["action"]->TagClassName = "ew-action-option";

        // Filter options
        $this->FilterOptions = new ListOptions("div");
        $this->FilterOptions->TagClassName = "ew-filter-option fverifyassetslistsrch";

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents($stream = null): string
    {
        global $Response;
        return is_object($Response) ? $Response->getBody() : ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $ExportFileName, $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

         // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }

        // Global Page Unloaded event (in userfn*.php)
        Page_Unloaded();

        // Export
        if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
            $content = $this->getContents();
            if ($ExportFileName == "") {
                $ExportFileName = $this->TableVar;
            }
            $class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
            if (class_exists($class)) {
                $doc = new $class(Container("verifyassets"));
                $doc->Text = @$content;
                if ($this->isExport("email")) {
                    echo $this->exportEmail($doc->Text);
                } else {
                    $doc->export();
                }
                DeleteTempImages(); // Delete temp images
                return;
            }
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show error
                WriteJson(array_merge(["success" => false], $this->getMessages()));
            }
            return;
        } else { // Check if response is JSON
            if (StartsString("application/json", $Response->getHeaderLine("Content-type")) && $Response->getBody()->getSize()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from recordset
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Recordset
            while ($rs && !$rs->EOF) {
                $this->loadRowValues($rs); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($rs->fields);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
                $rs->moveNext();
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DATATYPE_BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['Assetsid'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->Assetsid->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Updated_on->Visible = false;
        }
    }

    // Lookup data
    public function lookup()
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = Post("field");
        $lookup = $this->Fields[$fieldName]->Lookup;

        // Get lookup parameters
        $lookupType = Post("ajax", "unknown");
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal")) {
            $searchValue = Post("sv", "");
            $pageSize = Post("recperpage", 10);
            $offset = Post("start", 0);
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = Param("q", "");
            $pageSize = Param("n", -1);
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
            $start = Param("start", -1);
            $start = is_numeric($start) ? (int)$start : -1;
            $page = Param("page", -1);
            $page = is_numeric($page) ? (int)$page : -1;
            $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        }
        $userSelect = Decrypt(Post("s", ""));
        $userFilter = Decrypt(Post("f", ""));
        $userOrderBy = Decrypt(Post("o", ""));
        $keys = Post("keys");
        $lookup->LookupType = $lookupType; // Lookup type
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = Post("v" . $i, "");
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        $lookup->toJson($this); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchRowCount = 0; // For extended search
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $EditRowCount;
    public $StartRowCount = 1;
    public $RowCount = 0;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $RowAction = ""; // Row action
    public $MultiColumnClass = "col-sm";
    public $MultiColumnEditClass = "w-100";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $OldRecordset;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

        // Create form object
        $CurrentForm = new HttpForm();

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } elseif (IsPost()) {
            if (Post("exporttype") !== null) {
                $this->Export = Post("exporttype");
            }
            $custom = Post("custom", "");
        } elseif (Get("cmd") == "json") {
            $this->Export = Get("cmd");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportFileName = $this->TableVar; // Get export file, used in header

        // Get custom export parameters
        if ($this->isExport() && $custom != "") {
            $this->CustomExport = $this->Export;
            $this->Export = "print";
        }
        $CustomExportType = $this->CustomExport;
        $ExportType = $this->Export; // Get export parameter, used in header

        // Update Export URLs
        if (Config("USE_PHPEXCEL")) {
            $this->ExportExcelCustom = false;
        }
        if (Config("USE_PHPWORD")) {
            $this->ExportWordCustom = false;
        }
        if ($this->ExportExcelCustom) {
            $this->ExportExcelUrl .= "&amp;custom=1";
        }
        if ($this->ExportWordCustom) {
            $this->ExportWordUrl .= "&amp;custom=1";
        }
        if ($this->ExportPdfCustom) {
            $this->ExportPdfUrl .= "&amp;custom=1";
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->Assetsid->Visible = false;
        $this->Asset_No->setVisibility();
        $this->Custodian_id->setVisibility();
        $this->Details_of_Asset->setVisibility();
        $this->Asset_Status->setVisibility();
        $this->Condition_Of_Asset->setVisibility();
        $this->Location_id->setVisibility();
        $this->MDA_Parent->Visible = false;
        $this->MDA_id->setVisibility();
        $this->MDA_temp->Visible = false;
        $this->Category->setVisibility();
        $this->Category_Details->setVisibility();
        $this->Category_Temp->Visible = false;
        $this->Make->Visible = false;
        $this->Model->Visible = false;
        $this->YearofManufacture->Visible = false;
        $this->Colour->Visible = false;
        $this->EngineNumber->Visible = false;
        $this->ChasisNumber->Visible = false;
        $this->CivilianPlateNumber->Visible = false;
        $this->GovtPlateNumber->Visible = false;
        $this->Date_of_Acquisition->setVisibility();
        $this->Aquistion_Cost->setVisibility();
        $this->Additional_Cost->setVisibility();
        $this->Revaluation_Cost->setVisibility();
        $this->Remarks->Visible = false;
        $this->Created_By->Visible = false;
        $this->Created_on->Visible = false;
        $this->Updated_on->setVisibility();
        $this->hideFieldsForAddEdit();

        // Global Page Loading event (in userfn*.php)
        Page_Loading();

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up custom action (compatible with old version)
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions->add($name, $action);
        }

        // Show checkbox column if multiple action
        foreach ($this->ListActions->Items as $listaction) {
            if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
                $this->ListOptions["checkbox"]->Visible = true;
                break;
            }
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Custodian_id);
        $this->setupLookupOptions($this->Asset_Status);
        $this->setupLookupOptions($this->Condition_Of_Asset);
        $this->setupLookupOptions($this->Location_id);
        $this->setupLookupOptions($this->MDA_id);
        $this->setupLookupOptions($this->Category);

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $filter = "";

        // Get command
        $this->Command = strtolower(Get("cmd"));
        if ($this->isPageRequest()) {
            // Process list action first
            if ($this->processListAction()) { // Ajax request
                $this->terminate();
                return;
            }

            // Set up records per page
            $this->setupDisplayRecords();

            // Handle reset command
            $this->resetCmd();

            // Set up Breadcrumb
            if (!$this->isExport()) {
                $this->setupBreadcrumb();
            }

            // Check QueryString parameters
            if (Get("action") !== null) {
                $this->CurrentAction = Get("action");

                // Clear inline mode
                if ($this->isCancel()) {
                    $this->clearInlineMode();
                }

                // Switch to grid edit mode
                if ($this->isGridEdit()) {
                    $this->gridEditMode();
                }
            } else {
                if (Post("action") !== null) {
                    $this->CurrentAction = Post("action"); // Get action

                    // Grid Update
                    if (($this->isGridUpdate() || $this->isGridOverwrite()) && Session(SESSION_INLINE_MODE) == "gridedit") {
                        if ($this->validateGridForm()) {
                            $gridUpdate = $this->gridUpdate();
                        } else {
                            $gridUpdate = false;
                        }
                        if ($gridUpdate) {
                            $this->gridEditMode();
                        } else {
                            $this->EventCancelled = true;
                            $this->gridEditMode(); // Stay in Grid edit mode
                        }
                    }
                } elseif (Session(SESSION_INLINE_MODE) == "gridedit") { // Previously in grid edit mode
                    if (Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NO")) !== null) { // Stay in grid edit mode if paging
                        $this->gridEditMode();
                    } else { // Reset grid edit
                        $this->clearInlineMode();
                    }
                }
            }

            // Hide list options
            if ($this->isExport()) {
                $this->ListOptions->hideAllOptions(["sequence"]);
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            } elseif ($this->isGridAdd() || $this->isGridEdit()) {
                $this->ListOptions->hideAllOptions();
                $this->ListOptions->UseDropDownButton = false; // Disable drop down button
                $this->ListOptions->UseButtonGroup = false; // Disable button group
            }

            // Hide options
            if ($this->isExport() || $this->CurrentAction) {
                $this->ExportOptions->hideAllOptions();
                $this->FilterOptions->hideAllOptions();
                $this->ImportOptions->hideAllOptions();
            }

            // Hide other options
            if ($this->isExport()) {
                $this->OtherOptions->hideAllOptions();
            }

            // Show grid delete link for grid add / grid edit
            if ($this->AllowAddDeleteRow) {
                if ($this->isGridAdd() || $this->isGridEdit()) {
                    $item = $this->ListOptions["griddelete"];
                    if ($item) {
                        $item->Visible = true;
                    }
                }
            }

            // Get default search criteria
            AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

            // Get and validate search values for advanced search
            $this->loadSearchValues(); // Get search values

            // Process filter list
            if ($this->processFilterList()) {
                $this->terminate();
                return;
            }
            if (!$this->validateSearch()) {
                // Nothing to do
            }

            // Restore search parms from Session if not searching / reset / export
            if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
                $this->restoreSearchParms();
            }

            // Call Recordset SearchValidated event
            $this->recordsetSearchValidated();

            // Set up sorting order
            $this->setupSortOrder();

            // Get search criteria for advanced search
            if (!$this->hasInvalidFields()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load Sorting Order
        if ($this->Command != "json") {
            $this->loadSortOrder();
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms()) {
            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere();
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        AddFilter($this->SearchWhere, $srchAdvanced);
        AddFilter($this->SearchWhere, $srchBasic);

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json") {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        $filter = "";
        if (!$Security->canList()) {
            $filter = "(0=1)"; // Filter all records
        }
        AddFilter($filter, $this->DbDetailFilter);
        AddFilter($filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $filter;
        } else {
            $this->setSessionWhere($filter);
            $this->CurrentFilter = "";
        }

        // Export data only
        if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
            $this->exportData();
            $this->terminate();
            return;
        }
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if (!$this->CurrentAction && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Normal return
        if (IsApi()) {
            $rows = $this->getRecordsFromRecordset($this->Recordset);
            $this->Recordset->close();
            WriteJson(["success" => true, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
            $this->terminate(true);
            return;
        }

        // Set up pager
        $this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Pass table and field properties to client side
            $this->toClientVar(["tableCaption"], ["caption", "Visible", "Required", "IsInvalid", "Raw"]);

            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            Page_Rendering();

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }
        }
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->Aquistion_Cost->FormValue = ""; // Clear form value
        $this->Additional_Cost->FormValue = ""; // Clear form value
        $this->Revaluation_Cost->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to Grid Edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old recordset
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAll();
            $rs->closeCursor();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            return false;
        }

        // Begin transaction
        $conn->beginTransaction();
        $key = "";

        // Update row index and get row key
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete") { // Skip insert then deleted rows
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    //} elseif (!$this->validateForm()) { // Already done in validateGridForm
                    //    $gridUpdate = false; // Form error, reset action
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $conn->commit(); // Commit transaction

            // Get new records
            $rsnew = $conn->fetchAll($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->getSuccessMessage() == "") {
                $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
            }
            $this->clearInlineMode(); // Clear inline edit mode

            // Send notify email
            $table = 'verify assets';
            $subject = $table . " " . $Language->phrase("RecordUpdated");
            $action = $Language->phrase("ActionUpdatedGridEdit");
            $email = new Email();
            $email->load(Config("EMAIL_NOTIFY_TEMPLATE"));
            $email->replaceSender(Config("SENDER_EMAIL")); // Replace Sender
            $email->replaceRecipient(Config("RECIPIENT_EMAIL")); // Replace Recipient
            $email->replaceSubject($subject); // Replace Subject
            $email->replaceContent("<!--table-->", $table);
            $email->replaceContent("<!--key-->", $key);
            $email->replaceContent("<!--action-->", $action);
            $args = [];
            $args["rsold"] = &$rsold;
            $args["rsnew"] = &$rsnew;
            $emailSent = false;
            if ($this->emailSending($email, $args)) {
                $emailSent = $email->send();
            }

            // Set up error message
            if (!$emailSent) {
                $this->setFailureMessage($email->SendErrDescription);
            }
        } else {
            $conn->rollback(); // Rollback transaction
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if ($CurrentForm->hasValue("x_Asset_No") && $CurrentForm->hasValue("o_Asset_No") && $this->Asset_No->CurrentValue != $this->Asset_No->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Custodian_id") && $CurrentForm->hasValue("o_Custodian_id") && $this->Custodian_id->CurrentValue != $this->Custodian_id->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Details_of_Asset") && $CurrentForm->hasValue("o_Details_of_Asset") && $this->Details_of_Asset->CurrentValue != $this->Details_of_Asset->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Asset_Status") && $CurrentForm->hasValue("o_Asset_Status") && $this->Asset_Status->CurrentValue != $this->Asset_Status->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Condition_Of_Asset") && $CurrentForm->hasValue("o_Condition_Of_Asset") && $this->Condition_Of_Asset->CurrentValue != $this->Condition_Of_Asset->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Location_id") && $CurrentForm->hasValue("o_Location_id") && $this->Location_id->CurrentValue != $this->Location_id->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_MDA_id") && $CurrentForm->hasValue("o_MDA_id") && $this->MDA_id->CurrentValue != $this->MDA_id->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Category") && $CurrentForm->hasValue("o_Category") && $this->Category->CurrentValue != $this->Category->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Category_Details") && $CurrentForm->hasValue("o_Category_Details") && $this->Category_Details->CurrentValue != $this->Category_Details->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Date_of_Acquisition") && $CurrentForm->hasValue("o_Date_of_Acquisition") && $this->Date_of_Acquisition->CurrentValue != $this->Date_of_Acquisition->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Aquistion_Cost") && $CurrentForm->hasValue("o_Aquistion_Cost") && $this->Aquistion_Cost->CurrentValue != $this->Aquistion_Cost->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Additional_Cost") && $CurrentForm->hasValue("o_Additional_Cost") && $this->Additional_Cost->CurrentValue != $this->Additional_Cost->OldValue) {
            return false;
        }
        if ($CurrentForm->hasValue("x_Revaluation_Cost") && $CurrentForm->hasValue("o_Revaluation_Cost") && $this->Revaluation_Cost->CurrentValue != $this->Revaluation_Cost->OldValue) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->Index = -1;
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        $this->Asset_No->clearErrorMessage();
        $this->Custodian_id->clearErrorMessage();
        $this->Details_of_Asset->clearErrorMessage();
        $this->Asset_Status->clearErrorMessage();
        $this->Condition_Of_Asset->clearErrorMessage();
        $this->Location_id->clearErrorMessage();
        $this->MDA_id->clearErrorMessage();
        $this->Category->clearErrorMessage();
        $this->Category_Details->clearErrorMessage();
        $this->Date_of_Acquisition->clearErrorMessage();
        $this->Aquistion_Cost->clearErrorMessage();
        $this->Additional_Cost->clearErrorMessage();
        $this->Revaluation_Cost->clearErrorMessage();
        $this->Updated_on->clearErrorMessage();
    }

    // Get list of filters
    public function getFilterList()
    {
        global $UserProfile;

        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server" && isset($UserProfile)) {
            $savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fverifyassetslistsrch");
        }
        $filterList = Concat($filterList, $this->Assetsid->AdvancedSearch->toJson(), ","); // Field Assetsid
        $filterList = Concat($filterList, $this->Asset_No->AdvancedSearch->toJson(), ","); // Field Asset_No
        $filterList = Concat($filterList, $this->Custodian_id->AdvancedSearch->toJson(), ","); // Field Custodian_id
        $filterList = Concat($filterList, $this->Details_of_Asset->AdvancedSearch->toJson(), ","); // Field Details_of_Asset
        $filterList = Concat($filterList, $this->Asset_Status->AdvancedSearch->toJson(), ","); // Field Asset_Status
        $filterList = Concat($filterList, $this->Condition_Of_Asset->AdvancedSearch->toJson(), ","); // Field Condition_Of_Asset
        $filterList = Concat($filterList, $this->Location_id->AdvancedSearch->toJson(), ","); // Field Location_id
        $filterList = Concat($filterList, $this->MDA_Parent->AdvancedSearch->toJson(), ","); // Field MDA_Parent
        $filterList = Concat($filterList, $this->MDA_id->AdvancedSearch->toJson(), ","); // Field MDA_id
        $filterList = Concat($filterList, $this->MDA_temp->AdvancedSearch->toJson(), ","); // Field MDA_temp
        $filterList = Concat($filterList, $this->Category->AdvancedSearch->toJson(), ","); // Field Category
        $filterList = Concat($filterList, $this->Category_Details->AdvancedSearch->toJson(), ","); // Field Category_Details
        $filterList = Concat($filterList, $this->Category_Temp->AdvancedSearch->toJson(), ","); // Field Category_Temp
        $filterList = Concat($filterList, $this->Make->AdvancedSearch->toJson(), ","); // Field Make
        $filterList = Concat($filterList, $this->Model->AdvancedSearch->toJson(), ","); // Field Model
        $filterList = Concat($filterList, $this->YearofManufacture->AdvancedSearch->toJson(), ","); // Field Year of Manufacture
        $filterList = Concat($filterList, $this->Colour->AdvancedSearch->toJson(), ","); // Field Colour
        $filterList = Concat($filterList, $this->EngineNumber->AdvancedSearch->toJson(), ","); // Field Engine Number
        $filterList = Concat($filterList, $this->ChasisNumber->AdvancedSearch->toJson(), ","); // Field Chasis Number
        $filterList = Concat($filterList, $this->CivilianPlateNumber->AdvancedSearch->toJson(), ","); // Field Civilian Plate Number
        $filterList = Concat($filterList, $this->GovtPlateNumber->AdvancedSearch->toJson(), ","); // Field Govt Plate Number
        $filterList = Concat($filterList, $this->Date_of_Acquisition->AdvancedSearch->toJson(), ","); // Field Date_of_Acquisition
        $filterList = Concat($filterList, $this->Aquistion_Cost->AdvancedSearch->toJson(), ","); // Field Aquistion_Cost
        $filterList = Concat($filterList, $this->Additional_Cost->AdvancedSearch->toJson(), ","); // Field Additional_Cost
        $filterList = Concat($filterList, $this->Revaluation_Cost->AdvancedSearch->toJson(), ","); // Field Revaluation_Cost
        $filterList = Concat($filterList, $this->Remarks->AdvancedSearch->toJson(), ","); // Field Remarks
        $filterList = Concat($filterList, $this->Created_By->AdvancedSearch->toJson(), ","); // Field Created_By
        $filterList = Concat($filterList, $this->Created_on->AdvancedSearch->toJson(), ","); // Field Created_on
        $filterList = Concat($filterList, $this->Updated_on->AdvancedSearch->toJson(), ","); // Field Updated_on

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        global $UserProfile;
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            $UserProfile->setSearchFilters(CurrentUserName(), "fverifyassetslistsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field Assetsid
        $this->Assetsid->AdvancedSearch->SearchValue = @$filter["x_Assetsid"];
        $this->Assetsid->AdvancedSearch->SearchOperator = @$filter["z_Assetsid"];
        $this->Assetsid->AdvancedSearch->SearchCondition = @$filter["v_Assetsid"];
        $this->Assetsid->AdvancedSearch->SearchValue2 = @$filter["y_Assetsid"];
        $this->Assetsid->AdvancedSearch->SearchOperator2 = @$filter["w_Assetsid"];
        $this->Assetsid->AdvancedSearch->save();

        // Field Asset_No
        $this->Asset_No->AdvancedSearch->SearchValue = @$filter["x_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchOperator = @$filter["z_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchCondition = @$filter["v_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchValue2 = @$filter["y_Asset_No"];
        $this->Asset_No->AdvancedSearch->SearchOperator2 = @$filter["w_Asset_No"];
        $this->Asset_No->AdvancedSearch->save();

        // Field Custodian_id
        $this->Custodian_id->AdvancedSearch->SearchValue = @$filter["x_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchOperator = @$filter["z_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchCondition = @$filter["v_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchValue2 = @$filter["y_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->SearchOperator2 = @$filter["w_Custodian_id"];
        $this->Custodian_id->AdvancedSearch->save();

        // Field Details_of_Asset
        $this->Details_of_Asset->AdvancedSearch->SearchValue = @$filter["x_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchOperator = @$filter["z_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchCondition = @$filter["v_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchValue2 = @$filter["y_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->SearchOperator2 = @$filter["w_Details_of_Asset"];
        $this->Details_of_Asset->AdvancedSearch->save();

        // Field Asset_Status
        $this->Asset_Status->AdvancedSearch->SearchValue = @$filter["x_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchOperator = @$filter["z_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchCondition = @$filter["v_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchValue2 = @$filter["y_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->SearchOperator2 = @$filter["w_Asset_Status"];
        $this->Asset_Status->AdvancedSearch->save();

        // Field Condition_Of_Asset
        $this->Condition_Of_Asset->AdvancedSearch->SearchValue = @$filter["x_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperator = @$filter["z_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchCondition = @$filter["v_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchValue2 = @$filter["y_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->SearchOperator2 = @$filter["w_Condition_Of_Asset"];
        $this->Condition_Of_Asset->AdvancedSearch->save();

        // Field Location_id
        $this->Location_id->AdvancedSearch->SearchValue = @$filter["x_Location_id"];
        $this->Location_id->AdvancedSearch->SearchOperator = @$filter["z_Location_id"];
        $this->Location_id->AdvancedSearch->SearchCondition = @$filter["v_Location_id"];
        $this->Location_id->AdvancedSearch->SearchValue2 = @$filter["y_Location_id"];
        $this->Location_id->AdvancedSearch->SearchOperator2 = @$filter["w_Location_id"];
        $this->Location_id->AdvancedSearch->save();

        // Field MDA_Parent
        $this->MDA_Parent->AdvancedSearch->SearchValue = @$filter["x_MDA_Parent"];
        $this->MDA_Parent->AdvancedSearch->SearchOperator = @$filter["z_MDA_Parent"];
        $this->MDA_Parent->AdvancedSearch->SearchCondition = @$filter["v_MDA_Parent"];
        $this->MDA_Parent->AdvancedSearch->SearchValue2 = @$filter["y_MDA_Parent"];
        $this->MDA_Parent->AdvancedSearch->SearchOperator2 = @$filter["w_MDA_Parent"];
        $this->MDA_Parent->AdvancedSearch->save();

        // Field MDA_id
        $this->MDA_id->AdvancedSearch->SearchValue = @$filter["x_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchOperator = @$filter["z_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchCondition = @$filter["v_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchValue2 = @$filter["y_MDA_id"];
        $this->MDA_id->AdvancedSearch->SearchOperator2 = @$filter["w_MDA_id"];
        $this->MDA_id->AdvancedSearch->save();

        // Field MDA_temp
        $this->MDA_temp->AdvancedSearch->SearchValue = @$filter["x_MDA_temp"];
        $this->MDA_temp->AdvancedSearch->SearchOperator = @$filter["z_MDA_temp"];
        $this->MDA_temp->AdvancedSearch->SearchCondition = @$filter["v_MDA_temp"];
        $this->MDA_temp->AdvancedSearch->SearchValue2 = @$filter["y_MDA_temp"];
        $this->MDA_temp->AdvancedSearch->SearchOperator2 = @$filter["w_MDA_temp"];
        $this->MDA_temp->AdvancedSearch->save();

        // Field Category
        $this->Category->AdvancedSearch->SearchValue = @$filter["x_Category"];
        $this->Category->AdvancedSearch->SearchOperator = @$filter["z_Category"];
        $this->Category->AdvancedSearch->SearchCondition = @$filter["v_Category"];
        $this->Category->AdvancedSearch->SearchValue2 = @$filter["y_Category"];
        $this->Category->AdvancedSearch->SearchOperator2 = @$filter["w_Category"];
        $this->Category->AdvancedSearch->save();

        // Field Category_Details
        $this->Category_Details->AdvancedSearch->SearchValue = @$filter["x_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchOperator = @$filter["z_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchCondition = @$filter["v_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchValue2 = @$filter["y_Category_Details"];
        $this->Category_Details->AdvancedSearch->SearchOperator2 = @$filter["w_Category_Details"];
        $this->Category_Details->AdvancedSearch->save();

        // Field Category_Temp
        $this->Category_Temp->AdvancedSearch->SearchValue = @$filter["x_Category_Temp"];
        $this->Category_Temp->AdvancedSearch->SearchOperator = @$filter["z_Category_Temp"];
        $this->Category_Temp->AdvancedSearch->SearchCondition = @$filter["v_Category_Temp"];
        $this->Category_Temp->AdvancedSearch->SearchValue2 = @$filter["y_Category_Temp"];
        $this->Category_Temp->AdvancedSearch->SearchOperator2 = @$filter["w_Category_Temp"];
        $this->Category_Temp->AdvancedSearch->save();

        // Field Make
        $this->Make->AdvancedSearch->SearchValue = @$filter["x_Make"];
        $this->Make->AdvancedSearch->SearchOperator = @$filter["z_Make"];
        $this->Make->AdvancedSearch->SearchCondition = @$filter["v_Make"];
        $this->Make->AdvancedSearch->SearchValue2 = @$filter["y_Make"];
        $this->Make->AdvancedSearch->SearchOperator2 = @$filter["w_Make"];
        $this->Make->AdvancedSearch->save();

        // Field Model
        $this->Model->AdvancedSearch->SearchValue = @$filter["x_Model"];
        $this->Model->AdvancedSearch->SearchOperator = @$filter["z_Model"];
        $this->Model->AdvancedSearch->SearchCondition = @$filter["v_Model"];
        $this->Model->AdvancedSearch->SearchValue2 = @$filter["y_Model"];
        $this->Model->AdvancedSearch->SearchOperator2 = @$filter["w_Model"];
        $this->Model->AdvancedSearch->save();

        // Field Year of Manufacture
        $this->YearofManufacture->AdvancedSearch->SearchValue = @$filter["x_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchOperator = @$filter["z_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchCondition = @$filter["v_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchValue2 = @$filter["y_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->SearchOperator2 = @$filter["w_YearofManufacture"];
        $this->YearofManufacture->AdvancedSearch->save();

        // Field Colour
        $this->Colour->AdvancedSearch->SearchValue = @$filter["x_Colour"];
        $this->Colour->AdvancedSearch->SearchOperator = @$filter["z_Colour"];
        $this->Colour->AdvancedSearch->SearchCondition = @$filter["v_Colour"];
        $this->Colour->AdvancedSearch->SearchValue2 = @$filter["y_Colour"];
        $this->Colour->AdvancedSearch->SearchOperator2 = @$filter["w_Colour"];
        $this->Colour->AdvancedSearch->save();

        // Field Engine Number
        $this->EngineNumber->AdvancedSearch->SearchValue = @$filter["x_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchOperator = @$filter["z_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchCondition = @$filter["v_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchValue2 = @$filter["y_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->SearchOperator2 = @$filter["w_EngineNumber"];
        $this->EngineNumber->AdvancedSearch->save();

        // Field Chasis Number
        $this->ChasisNumber->AdvancedSearch->SearchValue = @$filter["x_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchOperator = @$filter["z_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchCondition = @$filter["v_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchValue2 = @$filter["y_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->SearchOperator2 = @$filter["w_ChasisNumber"];
        $this->ChasisNumber->AdvancedSearch->save();

        // Field Civilian Plate Number
        $this->CivilianPlateNumber->AdvancedSearch->SearchValue = @$filter["x_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchOperator = @$filter["z_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchCondition = @$filter["v_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchValue2 = @$filter["y_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->SearchOperator2 = @$filter["w_CivilianPlateNumber"];
        $this->CivilianPlateNumber->AdvancedSearch->save();

        // Field Govt Plate Number
        $this->GovtPlateNumber->AdvancedSearch->SearchValue = @$filter["x_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchOperator = @$filter["z_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchCondition = @$filter["v_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchValue2 = @$filter["y_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->SearchOperator2 = @$filter["w_GovtPlateNumber"];
        $this->GovtPlateNumber->AdvancedSearch->save();

        // Field Date_of_Acquisition
        $this->Date_of_Acquisition->AdvancedSearch->SearchValue = @$filter["x_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchOperator = @$filter["z_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchCondition = @$filter["v_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchValue2 = @$filter["y_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->SearchOperator2 = @$filter["w_Date_of_Acquisition"];
        $this->Date_of_Acquisition->AdvancedSearch->save();

        // Field Aquistion_Cost
        $this->Aquistion_Cost->AdvancedSearch->SearchValue = @$filter["x_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchOperator = @$filter["z_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchCondition = @$filter["v_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Aquistion_Cost"];
        $this->Aquistion_Cost->AdvancedSearch->save();

        // Field Additional_Cost
        $this->Additional_Cost->AdvancedSearch->SearchValue = @$filter["x_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchOperator = @$filter["z_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchCondition = @$filter["v_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Additional_Cost"];
        $this->Additional_Cost->AdvancedSearch->save();

        // Field Revaluation_Cost
        $this->Revaluation_Cost->AdvancedSearch->SearchValue = @$filter["x_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchOperator = @$filter["z_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchCondition = @$filter["v_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchValue2 = @$filter["y_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->SearchOperator2 = @$filter["w_Revaluation_Cost"];
        $this->Revaluation_Cost->AdvancedSearch->save();

        // Field Remarks
        $this->Remarks->AdvancedSearch->SearchValue = @$filter["x_Remarks"];
        $this->Remarks->AdvancedSearch->SearchOperator = @$filter["z_Remarks"];
        $this->Remarks->AdvancedSearch->SearchCondition = @$filter["v_Remarks"];
        $this->Remarks->AdvancedSearch->SearchValue2 = @$filter["y_Remarks"];
        $this->Remarks->AdvancedSearch->SearchOperator2 = @$filter["w_Remarks"];
        $this->Remarks->AdvancedSearch->save();

        // Field Created_By
        $this->Created_By->AdvancedSearch->SearchValue = @$filter["x_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator = @$filter["z_Created_By"];
        $this->Created_By->AdvancedSearch->SearchCondition = @$filter["v_Created_By"];
        $this->Created_By->AdvancedSearch->SearchValue2 = @$filter["y_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator2 = @$filter["w_Created_By"];
        $this->Created_By->AdvancedSearch->save();

        // Field Created_on
        $this->Created_on->AdvancedSearch->SearchValue = @$filter["x_Created_on"];
        $this->Created_on->AdvancedSearch->SearchOperator = @$filter["z_Created_on"];
        $this->Created_on->AdvancedSearch->SearchCondition = @$filter["v_Created_on"];
        $this->Created_on->AdvancedSearch->SearchValue2 = @$filter["y_Created_on"];
        $this->Created_on->AdvancedSearch->SearchOperator2 = @$filter["w_Created_on"];
        $this->Created_on->AdvancedSearch->save();

        // Field Updated_on
        $this->Updated_on->AdvancedSearch->SearchValue = @$filter["x_Updated_on"];
        $this->Updated_on->AdvancedSearch->SearchOperator = @$filter["z_Updated_on"];
        $this->Updated_on->AdvancedSearch->SearchCondition = @$filter["v_Updated_on"];
        $this->Updated_on->AdvancedSearch->SearchValue2 = @$filter["y_Updated_on"];
        $this->Updated_on->AdvancedSearch->SearchOperator2 = @$filter["w_Updated_on"];
        $this->Updated_on->AdvancedSearch->save();
    }

    // Advanced search WHERE clause based on QueryString
    protected function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->Assetsid, $default, false); // Assetsid
        $this->buildSearchSql($where, $this->Asset_No, $default, false); // Asset_No
        $this->buildSearchSql($where, $this->Custodian_id, $default, false); // Custodian_id
        $this->buildSearchSql($where, $this->Details_of_Asset, $default, false); // Details_of_Asset
        $this->buildSearchSql($where, $this->Asset_Status, $default, false); // Asset_Status
        $this->buildSearchSql($where, $this->Condition_Of_Asset, $default, false); // Condition_Of_Asset
        $this->buildSearchSql($where, $this->Location_id, $default, false); // Location_id
        $this->buildSearchSql($where, $this->MDA_Parent, $default, false); // MDA_Parent
        $this->buildSearchSql($where, $this->MDA_id, $default, false); // MDA_id
        $this->buildSearchSql($where, $this->MDA_temp, $default, false); // MDA_temp
        $this->buildSearchSql($where, $this->Category, $default, true); // Category
        $this->buildSearchSql($where, $this->Category_Details, $default, false); // Category_Details
        $this->buildSearchSql($where, $this->Category_Temp, $default, false); // Category_Temp
        $this->buildSearchSql($where, $this->Make, $default, false); // Make
        $this->buildSearchSql($where, $this->Model, $default, false); // Model
        $this->buildSearchSql($where, $this->YearofManufacture, $default, false); // Year of Manufacture
        $this->buildSearchSql($where, $this->Colour, $default, false); // Colour
        $this->buildSearchSql($where, $this->EngineNumber, $default, false); // Engine Number
        $this->buildSearchSql($where, $this->ChasisNumber, $default, false); // Chasis Number
        $this->buildSearchSql($where, $this->CivilianPlateNumber, $default, false); // Civilian Plate Number
        $this->buildSearchSql($where, $this->GovtPlateNumber, $default, false); // Govt Plate Number
        $this->buildSearchSql($where, $this->Date_of_Acquisition, $default, false); // Date_of_Acquisition
        $this->buildSearchSql($where, $this->Aquistion_Cost, $default, false); // Aquistion_Cost
        $this->buildSearchSql($where, $this->Additional_Cost, $default, false); // Additional_Cost
        $this->buildSearchSql($where, $this->Revaluation_Cost, $default, false); // Revaluation_Cost
        $this->buildSearchSql($where, $this->Remarks, $default, false); // Remarks
        $this->buildSearchSql($where, $this->Created_By, $default, false); // Created_By
        $this->buildSearchSql($where, $this->Created_on, $default, false); // Created_on
        $this->buildSearchSql($where, $this->Updated_on, $default, false); // Updated_on

        // Set up search parm
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->Assetsid->AdvancedSearch->save(); // Assetsid
            $this->Asset_No->AdvancedSearch->save(); // Asset_No
            $this->Custodian_id->AdvancedSearch->save(); // Custodian_id
            $this->Details_of_Asset->AdvancedSearch->save(); // Details_of_Asset
            $this->Asset_Status->AdvancedSearch->save(); // Asset_Status
            $this->Condition_Of_Asset->AdvancedSearch->save(); // Condition_Of_Asset
            $this->Location_id->AdvancedSearch->save(); // Location_id
            $this->MDA_Parent->AdvancedSearch->save(); // MDA_Parent
            $this->MDA_id->AdvancedSearch->save(); // MDA_id
            $this->MDA_temp->AdvancedSearch->save(); // MDA_temp
            $this->Category->AdvancedSearch->save(); // Category
            $this->Category_Details->AdvancedSearch->save(); // Category_Details
            $this->Category_Temp->AdvancedSearch->save(); // Category_Temp
            $this->Make->AdvancedSearch->save(); // Make
            $this->Model->AdvancedSearch->save(); // Model
            $this->YearofManufacture->AdvancedSearch->save(); // Year of Manufacture
            $this->Colour->AdvancedSearch->save(); // Colour
            $this->EngineNumber->AdvancedSearch->save(); // Engine Number
            $this->ChasisNumber->AdvancedSearch->save(); // Chasis Number
            $this->CivilianPlateNumber->AdvancedSearch->save(); // Civilian Plate Number
            $this->GovtPlateNumber->AdvancedSearch->save(); // Govt Plate Number
            $this->Date_of_Acquisition->AdvancedSearch->save(); // Date_of_Acquisition
            $this->Aquistion_Cost->AdvancedSearch->save(); // Aquistion_Cost
            $this->Additional_Cost->AdvancedSearch->save(); // Additional_Cost
            $this->Revaluation_Cost->AdvancedSearch->save(); // Revaluation_Cost
            $this->Remarks->AdvancedSearch->save(); // Remarks
            $this->Created_By->AdvancedSearch->save(); // Created_By
            $this->Created_on->AdvancedSearch->save(); // Created_on
            $this->Updated_on->AdvancedSearch->save(); // Updated_on
        }
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $wrk = "";
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldOpr = strtoupper(trim($fldOpr));
        if ($fldOpr == "") {
            $fldOpr = "=";
        }
        $fldOpr2 = strtoupper(trim($fldOpr2));
        if ($fldOpr2 == "") {
            $fldOpr2 = "=";
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            $wrk = $wrk1; // Build final SQL
            if ($wrk2 != "") {
                $wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
            }
        } else {
            $fldVal = $this->convertSearchValue($fld, $fldVal);
            $fldVal2 = $this->convertSearchValue($fld, $fldVal2);
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        AddFilter($where, $wrk);
    }

    // Convert search value
    protected function convertSearchValue(&$fld, $fldVal)
    {
        if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE")) {
            return $fldVal;
        }
        $value = $fldVal;
        if ($fld->isBoolean()) {
            if ($fldVal != "") {
                $value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
            }
        } elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
            if ($fldVal != "") {
                $value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
            }
        }
        return $value;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        if ($this->Assetsid->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Asset_No->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Custodian_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Details_of_Asset->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Asset_Status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Condition_Of_Asset->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Location_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MDA_Parent->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MDA_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->MDA_temp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Category_Details->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Category_Temp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Make->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Model->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->YearofManufacture->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Colour->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->EngineNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ChasisNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->CivilianPlateNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->GovtPlateNumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Date_of_Acquisition->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Aquistion_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Additional_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Revaluation_Cost->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Remarks->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_By->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_on->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Updated_on->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
                $this->Assetsid->AdvancedSearch->unsetSession();
                $this->Asset_No->AdvancedSearch->unsetSession();
                $this->Custodian_id->AdvancedSearch->unsetSession();
                $this->Details_of_Asset->AdvancedSearch->unsetSession();
                $this->Asset_Status->AdvancedSearch->unsetSession();
                $this->Condition_Of_Asset->AdvancedSearch->unsetSession();
                $this->Location_id->AdvancedSearch->unsetSession();
                $this->MDA_Parent->AdvancedSearch->unsetSession();
                $this->MDA_id->AdvancedSearch->unsetSession();
                $this->MDA_temp->AdvancedSearch->unsetSession();
                $this->Category->AdvancedSearch->unsetSession();
                $this->Category_Details->AdvancedSearch->unsetSession();
                $this->Category_Temp->AdvancedSearch->unsetSession();
                $this->Make->AdvancedSearch->unsetSession();
                $this->Model->AdvancedSearch->unsetSession();
                $this->YearofManufacture->AdvancedSearch->unsetSession();
                $this->Colour->AdvancedSearch->unsetSession();
                $this->EngineNumber->AdvancedSearch->unsetSession();
                $this->ChasisNumber->AdvancedSearch->unsetSession();
                $this->CivilianPlateNumber->AdvancedSearch->unsetSession();
                $this->GovtPlateNumber->AdvancedSearch->unsetSession();
                $this->Date_of_Acquisition->AdvancedSearch->unsetSession();
                $this->Aquistion_Cost->AdvancedSearch->unsetSession();
                $this->Additional_Cost->AdvancedSearch->unsetSession();
                $this->Revaluation_Cost->AdvancedSearch->unsetSession();
                $this->Remarks->AdvancedSearch->unsetSession();
                $this->Created_By->AdvancedSearch->unsetSession();
                $this->Created_on->AdvancedSearch->unsetSession();
                $this->Updated_on->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore advanced search values
                $this->Assetsid->AdvancedSearch->load();
                $this->Asset_No->AdvancedSearch->load();
                $this->Custodian_id->AdvancedSearch->load();
                $this->Details_of_Asset->AdvancedSearch->load();
                $this->Asset_Status->AdvancedSearch->load();
                $this->Condition_Of_Asset->AdvancedSearch->load();
                $this->Location_id->AdvancedSearch->load();
                $this->MDA_Parent->AdvancedSearch->load();
                $this->MDA_id->AdvancedSearch->load();
                $this->MDA_temp->AdvancedSearch->load();
                $this->Category->AdvancedSearch->load();
                $this->Category_Details->AdvancedSearch->load();
                $this->Category_Temp->AdvancedSearch->load();
                $this->Make->AdvancedSearch->load();
                $this->Model->AdvancedSearch->load();
                $this->YearofManufacture->AdvancedSearch->load();
                $this->Colour->AdvancedSearch->load();
                $this->EngineNumber->AdvancedSearch->load();
                $this->ChasisNumber->AdvancedSearch->load();
                $this->CivilianPlateNumber->AdvancedSearch->load();
                $this->GovtPlateNumber->AdvancedSearch->load();
                $this->Date_of_Acquisition->AdvancedSearch->load();
                $this->Aquistion_Cost->AdvancedSearch->load();
                $this->Additional_Cost->AdvancedSearch->load();
                $this->Revaluation_Cost->AdvancedSearch->load();
                $this->Remarks->AdvancedSearch->load();
                $this->Created_By->AdvancedSearch->load();
                $this->Created_on->AdvancedSearch->load();
                $this->Updated_on->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->Asset_No); // Asset_No
            $this->updateSort($this->Custodian_id); // Custodian_id
            $this->updateSort($this->Details_of_Asset); // Details_of_Asset
            $this->updateSort($this->Asset_Status); // Asset_Status
            $this->updateSort($this->Condition_Of_Asset); // Condition_Of_Asset
            $this->updateSort($this->Location_id); // Location_id
            $this->updateSort($this->MDA_id); // MDA_id
            $this->updateSort($this->Category); // Category
            $this->updateSort($this->Category_Details); // Category_Details
            $this->updateSort($this->Date_of_Acquisition); // Date_of_Acquisition
            $this->updateSort($this->Aquistion_Cost); // Aquistion_Cost
            $this->updateSort($this->Additional_Cost); // Additional_Cost
            $this->updateSort($this->Revaluation_Cost); // Revaluation_Cost
            $this->updateSort($this->Updated_on); // Updated_on
            $this->setStartRecordNumber(1); // Reset start position
        }
    }

    // Load sort order parameters
    protected function loadSortOrder()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        if ($orderBy == "") {
            $this->DefaultSort = "";
            if ($this->getSqlOrderBy() != "") {
                $useDefaultSort = true;
                if ($useDefaultSort) {
                    $orderBy = $this->getSqlOrderBy();
                    $this->setSessionOrderBy($orderBy);
                } else {
                    $this->setSessionOrderBy("");
                }
            }
        }
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->Assetsid->setSort("");
                $this->Asset_No->setSort("");
                $this->Custodian_id->setSort("");
                $this->Details_of_Asset->setSort("");
                $this->Asset_Status->setSort("");
                $this->Condition_Of_Asset->setSort("");
                $this->Location_id->setSort("");
                $this->MDA_Parent->setSort("");
                $this->MDA_id->setSort("");
                $this->MDA_temp->setSort("");
                $this->Category->setSort("");
                $this->Category_Details->setSort("");
                $this->Category_Temp->setSort("");
                $this->Make->setSort("");
                $this->Model->setSort("");
                $this->YearofManufacture->setSort("");
                $this->Colour->setSort("");
                $this->EngineNumber->setSort("");
                $this->ChasisNumber->setSort("");
                $this->CivilianPlateNumber->setSort("");
                $this->GovtPlateNumber->setSort("");
                $this->Date_of_Acquisition->setSort("");
                $this->Aquistion_Cost->setSort("");
                $this->Additional_Cost->setSort("");
                $this->Revaluation_Cost->setSort("");
                $this->Remarks->setSort("");
                $this->Created_By->setSort("");
                $this->Created_on->setSort("");
                $this->Updated_on->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item
        $item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
        $item->moveTo(0);
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // "sequence"
        $item = &$this->ListOptions->add("sequence");
        $item->CssClass = "text-nowrap";
        $item->Visible = true;
        $item->OnLeft = true; // Always on left
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = false;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }

        // "sequence"
        $opt = $this->ListOptions["sequence"];
        $opt->Body = FormatSequenceNumber($this->RecordCount);
        $pageUrl = $this->pageUrl();
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
                    $action = $listaction->Action;
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
                    $links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a></li>";
                    if (count($links) == 1) { // Single button
                        $body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(true) . "}," . $listaction->toJson(true) . "));\">" . $icon . $listaction->Caption . "</a>";
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
                $opt->Visible = true;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->Assetsid->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;

        // Add grid edit
        $option = $options["addedit"];
        $item = &$option->add("gridedit");
        $item->Body = "<a class=\"ew-add-edit ew-grid-edit\" title=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridEditLink")) . "\" href=\"" . HtmlEncode(GetUrl($this->GridEditUrl)) . "\">" . $Language->phrase("GridEditLink") . "</a>";
        $item->Visible = $this->GridEditUrl != "" && $Security->canEdit();
        $option = $options["action"];

        // Set up options default
        foreach ($options as $option) {
            $option->UseDropDownButton = false;
            $option->UseButtonGroup = true;
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->add($option->GroupOptionName);
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fverifyassetslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fverifyassetslistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        if (!$this->isGridAdd() && !$this->isGridEdit()) { // Not grid add/edit mode
            $option = $options["action"];
            // Set up list action buttons
            foreach ($this->ListActions->Items as $listaction) {
                if ($listaction->Select == ACTION_MULTIPLE) {
                    $item = &$option->add("custom_" . $listaction->Action);
                    $caption = $listaction->Caption;
                    $icon = ($listaction->Icon != "") ? '<i class="' . HtmlEncode($listaction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                    $item->Body = '<a class="ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" href="#" onclick="return ew.submitAction(event,jQuery.extend({f:document.fverifyassetslist},' . $listaction->toJson(true) . '));">' . $icon . '</a>';
                    $item->Visible = $listaction->Allow;
                }
            }

            // Hide grid edit and other options
            if ($this->TotalRecords <= 0) {
                $option = $options["addedit"];
                $item = $option["gridedit"];
                if ($item) {
                    $item->Visible = false;
                }
                $option = $options["action"];
                $option->hideAllOptions();
            }
        } else { // Grid add/edit mode
            // Hide all options first
            foreach ($options as $option) {
                $option->hideAllOptions();
            }
            $pageUrl = $this->pageUrl();

            // Grid-Edit
            if ($this->isGridEdit()) {
                if ($this->AllowAddDeleteRow) {
                    // Add add blank row
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"#\" onclick=\"return ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = false;
                }
                $option = $options["action"];
                $option->UseDropDownButton = false;
                    $item = &$option->add("gridsave");
                    $item->Body = "<a class=\"ew-action ew-grid-save\" title=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridSaveLink")) . "\" href=\"#\" onclick=\"ew.forms.get(this).submit(event, '" . $this->pageName() . "'); return false;\">" . $Language->phrase("GridSaveLink") . "</a>";
                    $item = &$option->add("gridcancel");
                    $cancelurl = $this->addMasterUrl($pageUrl . "action=cancel");
                    $item->Body = "<a class=\"ew-action ew-grid-cancel\" title=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("GridCancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("GridCancelLink") . "</a>";
            }
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security;
        $userlist = "";
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("useraction", "");
        if ($filter != "" && $userAction != "") {
            // Check permission first
            $actionCaption = $userAction;
            if (array_key_exists($userAction, $this->ListActions->Items)) {
                $actionCaption = $this->ListActions[$userAction]->Caption;
                if (!$this->ListActions[$userAction]->Allow) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            }
            $this->CurrentFilter = $filter;
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = LoadRecordset($sql, $conn, \PDO::FETCH_ASSOC);
            $this->CurrentAction = $userAction;

            // Call row action event
            if ($rs) {
                $conn->beginTransaction();
                $this->SelectedCount = $rs->recordCount();
                $this->SelectedIndex = 0;
                while (!$rs->EOF) {
                    $this->SelectedIndex++;
                    $row = $rs->fields;
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                    $rs->moveNext();
                }
                if ($processed) {
                    $conn->commit(); // Commit the changes
                    if ($this->getSuccessMessage() == "" && !ob_get_length()) { // No output
                        $this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    $conn->rollback(); // Rollback changes

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if ($rs) {
                $rs->close();
            }
            $this->CurrentAction = ""; // Clear action
            if (Post("ajax") == $userAction) { // Ajax
                if ($this->getSuccessMessage() != "") {
                    echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                    $this->clearSuccessMessage(); // Clear message
                }
                if ($this->getFailureMessage() != "") {
                    echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                    $this->clearFailureMessage(); // Clear message
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up list options (extended codes)
    protected function setupListOptionsExt()
    {
    }

    // Render list options (extended codes)
    protected function renderListOptionsExt()
    {
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->Assetsid->CurrentValue = null;
        $this->Assetsid->OldValue = $this->Assetsid->CurrentValue;
        $this->Asset_No->CurrentValue = null;
        $this->Asset_No->OldValue = $this->Asset_No->CurrentValue;
        $this->Custodian_id->CurrentValue = null;
        $this->Custodian_id->OldValue = $this->Custodian_id->CurrentValue;
        $this->Details_of_Asset->CurrentValue = null;
        $this->Details_of_Asset->OldValue = $this->Details_of_Asset->CurrentValue;
        $this->Asset_Status->CurrentValue = "Active";
        $this->Asset_Status->OldValue = $this->Asset_Status->CurrentValue;
        $this->Condition_Of_Asset->CurrentValue = "Good";
        $this->Condition_Of_Asset->OldValue = $this->Condition_Of_Asset->CurrentValue;
        $this->Location_id->CurrentValue = null;
        $this->Location_id->OldValue = $this->Location_id->CurrentValue;
        $this->MDA_Parent->CurrentValue = null;
        $this->MDA_Parent->OldValue = $this->MDA_Parent->CurrentValue;
        $this->MDA_id->CurrentValue = null;
        $this->MDA_id->OldValue = $this->MDA_id->CurrentValue;
        $this->MDA_temp->CurrentValue = null;
        $this->MDA_temp->OldValue = $this->MDA_temp->CurrentValue;
        $this->Category->CurrentValue = null;
        $this->Category->OldValue = $this->Category->CurrentValue;
        $this->Category_Details->CurrentValue = null;
        $this->Category_Details->OldValue = $this->Category_Details->CurrentValue;
        $this->Category_Temp->CurrentValue = null;
        $this->Category_Temp->OldValue = $this->Category_Temp->CurrentValue;
        $this->Make->CurrentValue = null;
        $this->Make->OldValue = $this->Make->CurrentValue;
        $this->Model->CurrentValue = null;
        $this->Model->OldValue = $this->Model->CurrentValue;
        $this->YearofManufacture->CurrentValue = null;
        $this->YearofManufacture->OldValue = $this->YearofManufacture->CurrentValue;
        $this->Colour->CurrentValue = null;
        $this->Colour->OldValue = $this->Colour->CurrentValue;
        $this->EngineNumber->CurrentValue = null;
        $this->EngineNumber->OldValue = $this->EngineNumber->CurrentValue;
        $this->ChasisNumber->CurrentValue = null;
        $this->ChasisNumber->OldValue = $this->ChasisNumber->CurrentValue;
        $this->CivilianPlateNumber->CurrentValue = null;
        $this->CivilianPlateNumber->OldValue = $this->CivilianPlateNumber->CurrentValue;
        $this->GovtPlateNumber->CurrentValue = null;
        $this->GovtPlateNumber->OldValue = $this->GovtPlateNumber->CurrentValue;
        $this->Date_of_Acquisition->CurrentValue = null;
        $this->Date_of_Acquisition->OldValue = $this->Date_of_Acquisition->CurrentValue;
        $this->Aquistion_Cost->CurrentValue = null;
        $this->Aquistion_Cost->OldValue = $this->Aquistion_Cost->CurrentValue;
        $this->Additional_Cost->CurrentValue = null;
        $this->Additional_Cost->OldValue = $this->Additional_Cost->CurrentValue;
        $this->Revaluation_Cost->CurrentValue = null;
        $this->Revaluation_Cost->OldValue = $this->Revaluation_Cost->CurrentValue;
        $this->Remarks->CurrentValue = null;
        $this->Remarks->OldValue = $this->Remarks->CurrentValue;
        $this->Created_By->CurrentValue = null;
        $this->Created_By->OldValue = $this->Created_By->CurrentValue;
        $this->Created_on->CurrentValue = null;
        $this->Created_on->OldValue = $this->Created_on->CurrentValue;
        $this->Updated_on->CurrentValue = null;
        $this->Updated_on->OldValue = $this->Updated_on->CurrentValue;
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Assetsid
        if (!$this->isAddOrEdit() && $this->Assetsid->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Assetsid->AdvancedSearch->SearchValue != "" || $this->Assetsid->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Asset_No
        if (!$this->isAddOrEdit() && $this->Asset_No->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Asset_No->AdvancedSearch->SearchValue != "" || $this->Asset_No->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Custodian_id
        if (!$this->isAddOrEdit() && $this->Custodian_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Custodian_id->AdvancedSearch->SearchValue != "" || $this->Custodian_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->Custodian_id->AdvancedSearch->SearchValue)) {
            $this->Custodian_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Custodian_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Custodian_id->AdvancedSearch->SearchValue2)) {
            $this->Custodian_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Custodian_id->AdvancedSearch->SearchValue2);
        }

        // Details_of_Asset
        if (!$this->isAddOrEdit() && $this->Details_of_Asset->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Details_of_Asset->AdvancedSearch->SearchValue != "" || $this->Details_of_Asset->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Asset_Status
        if (!$this->isAddOrEdit() && $this->Asset_Status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Asset_Status->AdvancedSearch->SearchValue != "" || $this->Asset_Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Condition_Of_Asset
        if (!$this->isAddOrEdit() && $this->Condition_Of_Asset->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Condition_Of_Asset->AdvancedSearch->SearchValue != "" || $this->Condition_Of_Asset->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Location_id
        if (!$this->isAddOrEdit() && $this->Location_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Location_id->AdvancedSearch->SearchValue != "" || $this->Location_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MDA_Parent
        if (!$this->isAddOrEdit() && $this->MDA_Parent->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MDA_Parent->AdvancedSearch->SearchValue != "" || $this->MDA_Parent->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MDA_id
        if (!$this->isAddOrEdit() && $this->MDA_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MDA_id->AdvancedSearch->SearchValue != "" || $this->MDA_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // MDA_temp
        if (!$this->isAddOrEdit() && $this->MDA_temp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->MDA_temp->AdvancedSearch->SearchValue != "" || $this->MDA_temp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Category
        if (!$this->isAddOrEdit() && $this->Category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Category->AdvancedSearch->SearchValue != "" || $this->Category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue)) {
            $this->Category->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Category->AdvancedSearch->SearchValue2)) {
            $this->Category->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue2);
        }

        // Category_Details
        if (!$this->isAddOrEdit() && $this->Category_Details->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Category_Details->AdvancedSearch->SearchValue != "" || $this->Category_Details->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Category_Temp
        if (!$this->isAddOrEdit() && $this->Category_Temp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Category_Temp->AdvancedSearch->SearchValue != "" || $this->Category_Temp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Make
        if (!$this->isAddOrEdit() && $this->Make->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Make->AdvancedSearch->SearchValue != "" || $this->Make->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Model
        if (!$this->isAddOrEdit() && $this->Model->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Model->AdvancedSearch->SearchValue != "" || $this->Model->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Year of Manufacture
        if (!$this->isAddOrEdit() && $this->YearofManufacture->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->YearofManufacture->AdvancedSearch->SearchValue != "" || $this->YearofManufacture->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Colour
        if (!$this->isAddOrEdit() && $this->Colour->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Colour->AdvancedSearch->SearchValue != "" || $this->Colour->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Engine Number
        if (!$this->isAddOrEdit() && $this->EngineNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->EngineNumber->AdvancedSearch->SearchValue != "" || $this->EngineNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Chasis Number
        if (!$this->isAddOrEdit() && $this->ChasisNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ChasisNumber->AdvancedSearch->SearchValue != "" || $this->ChasisNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Civilian Plate Number
        if (!$this->isAddOrEdit() && $this->CivilianPlateNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->CivilianPlateNumber->AdvancedSearch->SearchValue != "" || $this->CivilianPlateNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Govt Plate Number
        if (!$this->isAddOrEdit() && $this->GovtPlateNumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->GovtPlateNumber->AdvancedSearch->SearchValue != "" || $this->GovtPlateNumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Date_of_Acquisition
        if (!$this->isAddOrEdit() && $this->Date_of_Acquisition->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Date_of_Acquisition->AdvancedSearch->SearchValue != "" || $this->Date_of_Acquisition->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Aquistion_Cost
        if (!$this->isAddOrEdit() && $this->Aquistion_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Aquistion_Cost->AdvancedSearch->SearchValue != "" || $this->Aquistion_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Additional_Cost
        if (!$this->isAddOrEdit() && $this->Additional_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Additional_Cost->AdvancedSearch->SearchValue != "" || $this->Additional_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Revaluation_Cost
        if (!$this->isAddOrEdit() && $this->Revaluation_Cost->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Revaluation_Cost->AdvancedSearch->SearchValue != "" || $this->Revaluation_Cost->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Remarks
        if (!$this->isAddOrEdit() && $this->Remarks->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Remarks->AdvancedSearch->SearchValue != "" || $this->Remarks->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Created_By
        if (!$this->isAddOrEdit() && $this->Created_By->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_By->AdvancedSearch->SearchValue != "" || $this->Created_By->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Created_on
        if (!$this->isAddOrEdit() && $this->Created_on->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_on->AdvancedSearch->SearchValue != "" || $this->Created_on->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Updated_on
        if (!$this->isAddOrEdit() && $this->Updated_on->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Updated_on->AdvancedSearch->SearchValue != "" || $this->Updated_on->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;

        // Check field name 'Asset_No' first before field var 'x_Asset_No'
        $val = $CurrentForm->hasValue("Asset_No") ? $CurrentForm->getValue("Asset_No") : $CurrentForm->getValue("x_Asset_No");
        if (!$this->Asset_No->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Asset_No->Visible = false; // Disable update for API request
            } else {
                $this->Asset_No->setFormValue($val);
            }
        }

        // Check field name 'Custodian_id' first before field var 'x_Custodian_id'
        $val = $CurrentForm->hasValue("Custodian_id") ? $CurrentForm->getValue("Custodian_id") : $CurrentForm->getValue("x_Custodian_id");
        if (!$this->Custodian_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Custodian_id->Visible = false; // Disable update for API request
            } else {
                $this->Custodian_id->setFormValue($val);
            }
        }

        // Check field name 'Details_of_Asset' first before field var 'x_Details_of_Asset'
        $val = $CurrentForm->hasValue("Details_of_Asset") ? $CurrentForm->getValue("Details_of_Asset") : $CurrentForm->getValue("x_Details_of_Asset");
        if (!$this->Details_of_Asset->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Details_of_Asset->Visible = false; // Disable update for API request
            } else {
                $this->Details_of_Asset->setFormValue($val);
            }
        }

        // Check field name 'Asset_Status' first before field var 'x_Asset_Status'
        $val = $CurrentForm->hasValue("Asset_Status") ? $CurrentForm->getValue("Asset_Status") : $CurrentForm->getValue("x_Asset_Status");
        if (!$this->Asset_Status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Asset_Status->Visible = false; // Disable update for API request
            } else {
                $this->Asset_Status->setFormValue($val);
            }
        }

        // Check field name 'Condition_Of_Asset' first before field var 'x_Condition_Of_Asset'
        $val = $CurrentForm->hasValue("Condition_Of_Asset") ? $CurrentForm->getValue("Condition_Of_Asset") : $CurrentForm->getValue("x_Condition_Of_Asset");
        if (!$this->Condition_Of_Asset->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Condition_Of_Asset->Visible = false; // Disable update for API request
            } else {
                $this->Condition_Of_Asset->setFormValue($val);
            }
        }

        // Check field name 'Location_id' first before field var 'x_Location_id'
        $val = $CurrentForm->hasValue("Location_id") ? $CurrentForm->getValue("Location_id") : $CurrentForm->getValue("x_Location_id");
        if (!$this->Location_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Location_id->Visible = false; // Disable update for API request
            } else {
                $this->Location_id->setFormValue($val);
            }
        }

        // Check field name 'MDA_id' first before field var 'x_MDA_id'
        $val = $CurrentForm->hasValue("MDA_id") ? $CurrentForm->getValue("MDA_id") : $CurrentForm->getValue("x_MDA_id");
        if (!$this->MDA_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MDA_id->Visible = false; // Disable update for API request
            } else {
                $this->MDA_id->setFormValue($val);
            }
        }

        // Check field name 'Category' first before field var 'x_Category'
        $val = $CurrentForm->hasValue("Category") ? $CurrentForm->getValue("Category") : $CurrentForm->getValue("x_Category");
        if (!$this->Category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category->Visible = false; // Disable update for API request
            } else {
                $this->Category->setFormValue($val);
            }
        }

        // Check field name 'Category_Details' first before field var 'x_Category_Details'
        $val = $CurrentForm->hasValue("Category_Details") ? $CurrentForm->getValue("Category_Details") : $CurrentForm->getValue("x_Category_Details");
        if (!$this->Category_Details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Category_Details->Visible = false; // Disable update for API request
            } else {
                $this->Category_Details->setFormValue($val);
            }
        }

        // Check field name 'Date_of_Acquisition' first before field var 'x_Date_of_Acquisition'
        $val = $CurrentForm->hasValue("Date_of_Acquisition") ? $CurrentForm->getValue("Date_of_Acquisition") : $CurrentForm->getValue("x_Date_of_Acquisition");
        if (!$this->Date_of_Acquisition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Date_of_Acquisition->Visible = false; // Disable update for API request
            } else {
                $this->Date_of_Acquisition->setFormValue($val);
            }
            $this->Date_of_Acquisition->CurrentValue = UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0);
        }

        // Check field name 'Aquistion_Cost' first before field var 'x_Aquistion_Cost'
        $val = $CurrentForm->hasValue("Aquistion_Cost") ? $CurrentForm->getValue("Aquistion_Cost") : $CurrentForm->getValue("x_Aquistion_Cost");
        if (!$this->Aquistion_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Aquistion_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Aquistion_Cost->setFormValue($val);
            }
        }

        // Check field name 'Additional_Cost' first before field var 'x_Additional_Cost'
        $val = $CurrentForm->hasValue("Additional_Cost") ? $CurrentForm->getValue("Additional_Cost") : $CurrentForm->getValue("x_Additional_Cost");
        if (!$this->Additional_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Additional_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Additional_Cost->setFormValue($val);
            }
        }

        // Check field name 'Revaluation_Cost' first before field var 'x_Revaluation_Cost'
        $val = $CurrentForm->hasValue("Revaluation_Cost") ? $CurrentForm->getValue("Revaluation_Cost") : $CurrentForm->getValue("x_Revaluation_Cost");
        if (!$this->Revaluation_Cost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Revaluation_Cost->Visible = false; // Disable update for API request
            } else {
                $this->Revaluation_Cost->setFormValue($val);
            }
        }

        // Check field name 'Updated_on' first before field var 'x_Updated_on'
        $val = $CurrentForm->hasValue("Updated_on") ? $CurrentForm->getValue("Updated_on") : $CurrentForm->getValue("x_Updated_on");
        if (!$this->Updated_on->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Updated_on->Visible = false; // Disable update for API request
            } else {
                $this->Updated_on->setFormValue($val);
            }
            $this->Updated_on->CurrentValue = UnFormatDateTime($this->Updated_on->CurrentValue, 7);
        }

        // Check field name 'Assetsid' first before field var 'x_Assetsid'
        $val = $CurrentForm->hasValue("Assetsid") ? $CurrentForm->getValue("Assetsid") : $CurrentForm->getValue("x_Assetsid");
        if (!$this->Assetsid->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->Assetsid->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->Assetsid->CurrentValue = $this->Assetsid->FormValue;
        }
        $this->Asset_No->CurrentValue = $this->Asset_No->FormValue;
        $this->Custodian_id->CurrentValue = $this->Custodian_id->FormValue;
        $this->Details_of_Asset->CurrentValue = $this->Details_of_Asset->FormValue;
        $this->Asset_Status->CurrentValue = $this->Asset_Status->FormValue;
        $this->Condition_Of_Asset->CurrentValue = $this->Condition_Of_Asset->FormValue;
        $this->Location_id->CurrentValue = $this->Location_id->FormValue;
        $this->MDA_id->CurrentValue = $this->MDA_id->FormValue;
        $this->Category->CurrentValue = $this->Category->FormValue;
        $this->Category_Details->CurrentValue = $this->Category_Details->FormValue;
        $this->Date_of_Acquisition->CurrentValue = $this->Date_of_Acquisition->FormValue;
        $this->Date_of_Acquisition->CurrentValue = UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0);
        $this->Aquistion_Cost->CurrentValue = $this->Aquistion_Cost->FormValue;
        $this->Additional_Cost->CurrentValue = $this->Additional_Cost->FormValue;
        $this->Revaluation_Cost->CurrentValue = $this->Revaluation_Cost->FormValue;
        $this->Updated_on->CurrentValue = $this->Updated_on->FormValue;
        $this->Updated_on->CurrentValue = UnFormatDateTime($this->Updated_on->CurrentValue, 7);
    }

    // Load recordset
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load recordset
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $stmt = $sql->execute();
        $rs = new Recordset($stmt, $sql);

        // Call Recordset Selected event
        $this->recordsetSelected($rs);
        return $rs;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssoc($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
            if (!$this->EventCancelled) {
                $this->HashValue = $this->getRowHash($row); // Get hash value for record
            }
        }
        return $res;
    }

    /**
     * Load row values from recordset or record
     *
     * @param Recordset|array $rs Record
     * @return void
     */
    public function loadRowValues($rs = null)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            $row = $this->newRow();
        }

        // Call Row Selected event
        $this->rowSelected($row);
        if (!$rs) {
            return;
        }
        $this->Assetsid->setDbValue($row['Assetsid']);
        $this->Asset_No->setDbValue($row['Asset_No']);
        $this->Custodian_id->setDbValue($row['Custodian_id']);
        $this->Details_of_Asset->setDbValue($row['Details_of_Asset']);
        $this->Asset_Status->setDbValue($row['Asset_Status']);
        $this->Condition_Of_Asset->setDbValue($row['Condition_Of_Asset']);
        $this->Location_id->setDbValue($row['Location_id']);
        $this->MDA_Parent->setDbValue($row['MDA_Parent']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->MDA_temp->setDbValue($row['MDA_temp']);
        $this->Category->setDbValue($row['Category']);
        $this->Category_Details->setDbValue($row['Category_Details']);
        $this->Category_Temp->setDbValue($row['Category_Temp']);
        $this->Make->setDbValue($row['Make']);
        $this->Model->setDbValue($row['Model']);
        $this->YearofManufacture->setDbValue($row['Year of Manufacture']);
        $this->Colour->setDbValue($row['Colour']);
        $this->EngineNumber->setDbValue($row['Engine Number']);
        $this->ChasisNumber->setDbValue($row['Chasis Number']);
        $this->CivilianPlateNumber->setDbValue($row['Civilian Plate Number']);
        $this->GovtPlateNumber->setDbValue($row['Govt Plate Number']);
        $this->Date_of_Acquisition->setDbValue($row['Date_of_Acquisition']);
        $this->Aquistion_Cost->setDbValue($row['Aquistion_Cost']);
        $this->Additional_Cost->setDbValue($row['Additional_Cost']);
        $this->Revaluation_Cost->setDbValue($row['Revaluation_Cost']);
        $this->Remarks->setDbValue($row['Remarks']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $this->loadDefaultValues();
        $row = [];
        $row['Assetsid'] = $this->Assetsid->CurrentValue;
        $row['Asset_No'] = $this->Asset_No->CurrentValue;
        $row['Custodian_id'] = $this->Custodian_id->CurrentValue;
        $row['Details_of_Asset'] = $this->Details_of_Asset->CurrentValue;
        $row['Asset_Status'] = $this->Asset_Status->CurrentValue;
        $row['Condition_Of_Asset'] = $this->Condition_Of_Asset->CurrentValue;
        $row['Location_id'] = $this->Location_id->CurrentValue;
        $row['MDA_Parent'] = $this->MDA_Parent->CurrentValue;
        $row['MDA_id'] = $this->MDA_id->CurrentValue;
        $row['MDA_temp'] = $this->MDA_temp->CurrentValue;
        $row['Category'] = $this->Category->CurrentValue;
        $row['Category_Details'] = $this->Category_Details->CurrentValue;
        $row['Category_Temp'] = $this->Category_Temp->CurrentValue;
        $row['Make'] = $this->Make->CurrentValue;
        $row['Model'] = $this->Model->CurrentValue;
        $row['Year of Manufacture'] = $this->YearofManufacture->CurrentValue;
        $row['Colour'] = $this->Colour->CurrentValue;
        $row['Engine Number'] = $this->EngineNumber->CurrentValue;
        $row['Chasis Number'] = $this->ChasisNumber->CurrentValue;
        $row['Civilian Plate Number'] = $this->CivilianPlateNumber->CurrentValue;
        $row['Govt Plate Number'] = $this->GovtPlateNumber->CurrentValue;
        $row['Date_of_Acquisition'] = $this->Date_of_Acquisition->CurrentValue;
        $row['Aquistion_Cost'] = $this->Aquistion_Cost->CurrentValue;
        $row['Additional_Cost'] = $this->Additional_Cost->CurrentValue;
        $row['Revaluation_Cost'] = $this->Revaluation_Cost->CurrentValue;
        $row['Remarks'] = $this->Remarks->CurrentValue;
        $row['Created_By'] = $this->Created_By->CurrentValue;
        $row['Created_on'] = $this->Created_on->CurrentValue;
        $row['Updated_on'] = $this->Updated_on->CurrentValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        $this->OldRecordset = null;
        $validKey = $this->OldKey != "";
        if ($validKey) {
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $this->OldRecordset = LoadRecordset($sql, $conn);
        }
        $this->loadRowValues($this->OldRecordset); // Load row values
        return $validKey;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Convert decimal values if posted back
        if ($this->Aquistion_Cost->FormValue == $this->Aquistion_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Aquistion_Cost->CurrentValue))) {
            $this->Aquistion_Cost->CurrentValue = ConvertToFloatString($this->Aquistion_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Additional_Cost->FormValue == $this->Additional_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Additional_Cost->CurrentValue))) {
            $this->Additional_Cost->CurrentValue = ConvertToFloatString($this->Additional_Cost->CurrentValue);
        }

        // Convert decimal values if posted back
        if ($this->Revaluation_Cost->FormValue == $this->Revaluation_Cost->CurrentValue && is_numeric(ConvertToFloatString($this->Revaluation_Cost->CurrentValue))) {
            $this->Revaluation_Cost->CurrentValue = ConvertToFloatString($this->Revaluation_Cost->CurrentValue);
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Assetsid

        // Asset_No
        $this->Asset_No->CellCssStyle = "min-width: 200px; white-space: nowrap;";

        // Custodian_id

        // Details_of_Asset
        $this->Details_of_Asset->CellCssStyle = "min-width: 250px;";

        // Asset_Status
        $this->Asset_Status->CellCssStyle = "min-width: 50px;";

        // Condition_Of_Asset
        $this->Condition_Of_Asset->CellCssStyle = "min-width: 50px;";

        // Location_id
        $this->Location_id->CellCssStyle = "min-width: 200px;";

        // MDA_Parent

        // MDA_id
        $this->MDA_id->CellCssStyle = "min-width: 100px;";

        // MDA_temp

        // Category

        // Category_Details
        $this->Category_Details->CellCssStyle = "min-width: 150px;";

        // Category_Temp
        $this->Category_Temp->CellCssStyle = "min-width: 150px;";

        // Make

        // Model

        // Year of Manufacture

        // Colour

        // Engine Number

        // Chasis Number

        // Civilian Plate Number

        // Govt Plate Number

        // Date_of_Acquisition
        $this->Date_of_Acquisition->CellCssStyle = "min-width: 120px;";

        // Aquistion_Cost
        $this->Aquistion_Cost->CellCssStyle = "min-width: 120px;";

        // Additional_Cost
        $this->Additional_Cost->CellCssStyle = "min-width: 120px;";

        // Revaluation_Cost

        // Remarks

        // Created_By

        // Created_on

        // Updated_on
        if ($this->RowType == ROWTYPE_VIEW) {
            // Asset_No
            $this->Asset_No->ViewValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->ViewCustomAttributes = "";

            // Custodian_id
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
                if ($this->Custodian_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Custodian_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Custodian_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Custodian_id->Lookup->renderViewRow($row);
                            $this->Custodian_id->ViewValue->add($this->Custodian_id->displayValue($arwrk));
                        }
                    } else {
                        $this->Custodian_id->ViewValue = $this->Custodian_id->CurrentValue;
                    }
                }
            } else {
                $this->Custodian_id->ViewValue = null;
            }
            $this->Custodian_id->ViewCustomAttributes = "";

            // Details_of_Asset
            $this->Details_of_Asset->ViewValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Asset_Status
            $curVal = trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
                if ($this->Asset_Status->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Asset_Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Asset_Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Asset_Status->ViewValue = $this->Asset_Status->displayValue($arwrk);
                    } else {
                        $this->Asset_Status->ViewValue = $this->Asset_Status->CurrentValue;
                    }
                }
            } else {
                $this->Asset_Status->ViewValue = null;
            }
            $this->Asset_Status->ViewCustomAttributes = "";

            // Condition_Of_Asset
            $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
                if ($this->Condition_Of_Asset->ViewValue === null) { // Lookup from database
                    $filterWrk = "`status`" . SearchString("=", $curVal, DATATYPE_STRING, "");
                    $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Condition_Of_Asset->Lookup->renderViewRow($rswrk[0]);
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->displayValue($arwrk);
                    } else {
                        $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->CurrentValue;
                    }
                }
            } else {
                $this->Condition_Of_Asset->ViewValue = null;
            }
            $this->Condition_Of_Asset->ViewCustomAttributes = "";

            // Location_id
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->ViewValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->ViewValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->ViewValue = null;
            }
            $this->Location_id->ViewCustomAttributes = "";

            // MDA_id
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->ViewValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->ViewValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->ViewValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";

            // Category
            $curVal = trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->ViewValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->ViewValue = $this->Category_Details->CurrentValue;
            $this->Category_Details->ViewCustomAttributes = "";

            // Category_Temp
            $this->Category_Temp->ViewValue = $this->Category_Temp->CurrentValue;
            $this->Category_Temp->ViewCustomAttributes = "";

            // Make
            $this->Make->ViewValue = $this->Make->CurrentValue;
            $this->Make->ViewCustomAttributes = "";

            // Model
            $this->Model->ViewValue = $this->Model->CurrentValue;
            $this->Model->ViewCustomAttributes = "";

            // Year of Manufacture
            $this->YearofManufacture->ViewValue = $this->YearofManufacture->CurrentValue;
            $this->YearofManufacture->ViewValue = FormatNumber($this->YearofManufacture->ViewValue, 0, -2, -2, -2);
            $this->YearofManufacture->ViewCustomAttributes = "";

            // Colour
            $this->Colour->ViewValue = $this->Colour->CurrentValue;
            $this->Colour->ViewCustomAttributes = "";

            // Engine Number
            $this->EngineNumber->ViewValue = $this->EngineNumber->CurrentValue;
            $this->EngineNumber->ViewCustomAttributes = "";

            // Chasis Number
            $this->ChasisNumber->ViewValue = $this->ChasisNumber->CurrentValue;
            $this->ChasisNumber->ViewCustomAttributes = "";

            // Civilian Plate Number
            $this->CivilianPlateNumber->ViewValue = $this->CivilianPlateNumber->CurrentValue;
            $this->CivilianPlateNumber->ViewCustomAttributes = "";

            // Govt Plate Number
            $this->GovtPlateNumber->ViewValue = $this->GovtPlateNumber->CurrentValue;
            $this->GovtPlateNumber->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->ViewValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->ViewValue = FormatDateTime($this->Date_of_Acquisition->ViewValue, 0);
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->ViewValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->ViewValue = FormatNumber($this->Aquistion_Cost->ViewValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->ViewValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->ViewValue = FormatNumber($this->Additional_Cost->ViewValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->ViewValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->ViewValue = FormatNumber($this->Revaluation_Cost->ViewValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;
            $this->Created_By->ViewValue = FormatNumber($this->Created_By->ViewValue, 0, -2, -2, -2);
            $this->Created_By->ViewCustomAttributes = "";

            // Created_on
            $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
            $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
            $this->Created_on->ViewCustomAttributes = "";

            // Updated_on
            $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
            $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 7);
            $this->Updated_on->ViewCustomAttributes = "";

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";
            $this->Custodian_id->TooltipValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";
            $this->Asset_Status->TooltipValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";
            $this->Condition_Of_Asset->TooltipValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
            $this->Updated_on->TooltipValue = "";
        } elseif ($this->RowType == ROWTYPE_ADD) {
            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            if (!$this->Asset_No->Raw) {
                $this->Asset_No->CurrentValue = HtmlDecode($this->Asset_No->CurrentValue);
            }
            $this->Asset_No->EditValue = HtmlEncode($this->Asset_No->CurrentValue);
            $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

            // Custodian_id
            $this->Custodian_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            } else {
                $this->Custodian_id->ViewValue = $this->Custodian_id->Lookup !== null && is_array($this->Custodian_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Custodian_id->ViewValue !== null) { // Load from cache
                $this->Custodian_id->EditValue = array_values($this->Custodian_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->Custodian_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Custodian_id->EditValue = $arwrk;
            }
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            if (!$this->Details_of_Asset->Raw) {
                $this->Details_of_Asset->CurrentValue = HtmlDecode($this->Details_of_Asset->CurrentValue);
            }
            $this->Details_of_Asset->EditValue = HtmlEncode($this->Details_of_Asset->CurrentValue);
            $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->ViewValue = $this->Location_id->lookupCacheOption($curVal);
            } else {
                $this->Location_id->ViewValue = $this->Location_id->Lookup !== null && is_array($this->Location_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Location_id->ViewValue !== null) { // Load from cache
                $this->Location_id->EditValue = array_values($this->Location_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Locationid`" . SearchString("=", $this->Location_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->Location_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Location_id->EditValue = $arwrk;
            }
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->ViewValue = $this->MDA_id->lookupCacheOption($curVal);
            } else {
                $this->MDA_id->ViewValue = $this->MDA_id->Lookup !== null && is_array($this->MDA_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->MDA_id->ViewValue !== null) { // Load from cache
                $this->MDA_id->EditValue = array_values($this->MDA_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`MDAID`" . SearchString("=", $this->MDA_id->CurrentValue, DATATYPE_NUMBER, "");
                }
                $sqlWrk = $this->MDA_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MDA_id->EditValue = $arwrk;
            }
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

            // Category
            $this->Category->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
            } else {
                $this->Category->ViewValue = $this->Category->Lookup !== null && is_array($this->Category->Lookup->Options) ? $curVal : null;
            }
            if ($this->Category->ViewValue !== null) { // Load from cache
                $this->Category->EditValue = array_values($this->Category->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->Category->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category->EditValue = $arwrk;
            }
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            if (!$this->Category_Details->Raw) {
                $this->Category_Details->CurrentValue = HtmlDecode($this->Category_Details->CurrentValue);
            }
            $this->Category_Details->EditValue = HtmlEncode($this->Category_Details->CurrentValue);
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime($this->Date_of_Acquisition->CurrentValue, 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->CurrentValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());
            if (strval($this->Aquistion_Cost->EditValue) != "" && is_numeric($this->Aquistion_Cost->EditValue)) {
                $this->Aquistion_Cost->EditValue = FormatNumber($this->Aquistion_Cost->EditValue, -2, -2, -2, -2);
            }

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = HtmlEncode($this->Additional_Cost->CurrentValue);
            $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());
            if (strval($this->Additional_Cost->EditValue) != "" && is_numeric($this->Additional_Cost->EditValue)) {
                $this->Additional_Cost->EditValue = FormatNumber($this->Additional_Cost->EditValue, -2, -2, -2, -2);
            }

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = HtmlEncode($this->Revaluation_Cost->CurrentValue);
            $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());
            if (strval($this->Revaluation_Cost->EditValue) != "" && is_numeric($this->Revaluation_Cost->EditValue)) {
                $this->Revaluation_Cost->EditValue = FormatNumber($this->Revaluation_Cost->EditValue, -2, -2, -2, -2);
            }

            // Updated_on

            // Add refer script

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_EDIT) {
            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            $this->Asset_No->EditValue = $this->Asset_No->CurrentValue;
            $this->Asset_No->ViewCustomAttributes = "";

            // Custodian_id
            $this->Custodian_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Custodian_id->CurrentValue));
            if ($curVal != "") {
                $this->Custodian_id->ViewValue = $this->Custodian_id->lookupCacheOption($curVal);
            } else {
                $this->Custodian_id->ViewValue = $this->Custodian_id->Lookup !== null && is_array($this->Custodian_id->Lookup->Options) ? $curVal : null;
            }
            if ($this->Custodian_id->ViewValue !== null) { // Load from cache
                $this->Custodian_id->EditValue = array_values($this->Custodian_id->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                }
                $sqlWrk = $this->Custodian_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Custodian_id->EditValue = $arwrk;
            }
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            $this->Details_of_Asset->EditValue = $this->Details_of_Asset->CurrentValue;
            $this->Details_of_Asset->ViewCustomAttributes = "";

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = trim(strval($this->Asset_Status->CurrentValue));
            if ($curVal != "") {
                $this->Asset_Status->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = trim(strval($this->Condition_Of_Asset->CurrentValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->CurrentValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->Location_id->CurrentValue));
            if ($curVal != "") {
                $this->Location_id->EditValue = $this->Location_id->lookupCacheOption($curVal);
                if ($this->Location_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`Locationid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->Location_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Location_id->Lookup->renderViewRow($rswrk[0]);
                        $this->Location_id->EditValue = $this->Location_id->displayValue($arwrk);
                    } else {
                        $this->Location_id->EditValue = $this->Location_id->CurrentValue;
                    }
                }
            } else {
                $this->Location_id->EditValue = null;
            }
            $this->Location_id->ViewCustomAttributes = "";

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            $curVal = trim(strval($this->MDA_id->CurrentValue));
            if ($curVal != "") {
                $this->MDA_id->EditValue = $this->MDA_id->lookupCacheOption($curVal);
                if ($this->MDA_id->EditValue === null) { // Lookup from database
                    $filterWrk = "`MDAID`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                    $sqlWrk = $this->MDA_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MDA_id->Lookup->renderViewRow($rswrk[0]);
                        $this->MDA_id->EditValue = $this->MDA_id->displayValue($arwrk);
                    } else {
                        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
                    }
                }
            } else {
                $this->MDA_id->EditValue = null;
            }
            $this->MDA_id->ViewCustomAttributes = "";

            // Category
            $this->Category->EditAttrs["class"] = "form-control";
            $this->Category->EditCustomAttributes = "";
            $curVal = trim(strval($this->Category->CurrentValue));
            if ($curVal != "") {
                $this->Category->EditValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->EditValue === null) { // Lookup from database
                    $arwrk = explode(",", $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        if ($filterWrk != "") {
                            $filterWrk .= " OR ";
                        }
                        $filterWrk .= "`Categoryid`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
                    }
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->Category->EditValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->Category->Lookup->renderViewRow($row);
                            $this->Category->EditValue->add($this->Category->displayValue($arwrk));
                        }
                    } else {
                        $this->Category->EditValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->EditValue = null;
            }
            $this->Category->ViewCustomAttributes = "";

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            $this->Category_Details->EditValue = $this->Category_Details->CurrentValue;
            $this->Category_Details->ViewCustomAttributes = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = $this->Date_of_Acquisition->CurrentValue;
            $this->Date_of_Acquisition->EditValue = FormatDateTime($this->Date_of_Acquisition->EditValue, 0);
            $this->Date_of_Acquisition->ViewCustomAttributes = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = $this->Aquistion_Cost->CurrentValue;
            $this->Aquistion_Cost->EditValue = FormatNumber($this->Aquistion_Cost->EditValue, 2, -2, -2, -2);
            $this->Aquistion_Cost->CellCssStyle .= "text-align: right;";
            $this->Aquistion_Cost->ViewCustomAttributes = "";

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = $this->Additional_Cost->CurrentValue;
            $this->Additional_Cost->EditValue = FormatNumber($this->Additional_Cost->EditValue, 2, -2, -2, -2);
            $this->Additional_Cost->CellCssStyle .= "text-align: right;";
            $this->Additional_Cost->ViewCustomAttributes = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = $this->Revaluation_Cost->CurrentValue;
            $this->Revaluation_Cost->EditValue = FormatNumber($this->Revaluation_Cost->EditValue, 2, -2, -2, -2);
            $this->Revaluation_Cost->CellCssStyle .= "text-align: right;";
            $this->Revaluation_Cost->ViewCustomAttributes = "";

            // Updated_on

            // Edit refer script

            // Asset_No
            $this->Asset_No->LinkCustomAttributes = "";
            $this->Asset_No->HrefValue = "";
            $this->Asset_No->TooltipValue = "";

            // Custodian_id
            $this->Custodian_id->LinkCustomAttributes = "";
            $this->Custodian_id->HrefValue = "";

            // Details_of_Asset
            $this->Details_of_Asset->LinkCustomAttributes = "";
            $this->Details_of_Asset->HrefValue = "";
            $this->Details_of_Asset->TooltipValue = "";

            // Asset_Status
            $this->Asset_Status->LinkCustomAttributes = "";
            $this->Asset_Status->HrefValue = "";

            // Condition_Of_Asset
            $this->Condition_Of_Asset->LinkCustomAttributes = "";
            $this->Condition_Of_Asset->HrefValue = "";

            // Location_id
            $this->Location_id->LinkCustomAttributes = "";
            $this->Location_id->HrefValue = "";
            $this->Location_id->TooltipValue = "";

            // MDA_id
            $this->MDA_id->LinkCustomAttributes = "";
            $this->MDA_id->HrefValue = "";
            $this->MDA_id->TooltipValue = "";

            // Category
            $this->Category->LinkCustomAttributes = "";
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Category_Details
            $this->Category_Details->LinkCustomAttributes = "";
            $this->Category_Details->HrefValue = "";
            $this->Category_Details->TooltipValue = "";

            // Date_of_Acquisition
            $this->Date_of_Acquisition->LinkCustomAttributes = "";
            $this->Date_of_Acquisition->HrefValue = "";
            $this->Date_of_Acquisition->TooltipValue = "";

            // Aquistion_Cost
            $this->Aquistion_Cost->LinkCustomAttributes = "";
            $this->Aquistion_Cost->HrefValue = "";
            $this->Aquistion_Cost->TooltipValue = "";

            // Additional_Cost
            $this->Additional_Cost->LinkCustomAttributes = "";
            $this->Additional_Cost->HrefValue = "";
            $this->Additional_Cost->TooltipValue = "";

            // Revaluation_Cost
            $this->Revaluation_Cost->LinkCustomAttributes = "";
            $this->Revaluation_Cost->HrefValue = "";
            $this->Revaluation_Cost->TooltipValue = "";

            // Updated_on
            $this->Updated_on->LinkCustomAttributes = "";
            $this->Updated_on->HrefValue = "";
        } elseif ($this->RowType == ROWTYPE_SEARCH) {
            // Asset_No
            $this->Asset_No->EditAttrs["class"] = "form-control";
            $this->Asset_No->EditCustomAttributes = "";
            if (!$this->Asset_No->Raw) {
                $this->Asset_No->AdvancedSearch->SearchValue = HtmlDecode($this->Asset_No->AdvancedSearch->SearchValue);
            }
            $this->Asset_No->EditValue = HtmlEncode($this->Asset_No->AdvancedSearch->SearchValue);
            $this->Asset_No->PlaceHolder = RemoveHtml($this->Asset_No->caption());

            // Custodian_id
            $this->Custodian_id->EditCustomAttributes = "";
            $this->Custodian_id->PlaceHolder = RemoveHtml($this->Custodian_id->caption());

            // Details_of_Asset
            $this->Details_of_Asset->EditAttrs["class"] = "form-control";
            $this->Details_of_Asset->EditCustomAttributes = "";
            if (!$this->Details_of_Asset->Raw) {
                $this->Details_of_Asset->AdvancedSearch->SearchValue = HtmlDecode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            }
            $this->Details_of_Asset->EditValue = HtmlEncode($this->Details_of_Asset->AdvancedSearch->SearchValue);
            $this->Details_of_Asset->PlaceHolder = RemoveHtml($this->Details_of_Asset->caption());

            // Asset_Status
            $this->Asset_Status->EditAttrs["class"] = "form-control";
            $this->Asset_Status->EditCustomAttributes = "";
            $curVal = trim(strval($this->Asset_Status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->lookupCacheOption($curVal);
            } else {
                $this->Asset_Status->AdvancedSearch->ViewValue = $this->Asset_Status->Lookup !== null && is_array($this->Asset_Status->Lookup->Options) ? $curVal : null;
            }
            if ($this->Asset_Status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Asset_Status->EditValue = array_values($this->Asset_Status->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`Status`" . SearchString("=", $this->Asset_Status->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Asset_Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Asset_Status->EditValue = $arwrk;
            }
            $this->Asset_Status->PlaceHolder = RemoveHtml($this->Asset_Status->caption());

            // Condition_Of_Asset
            $this->Condition_Of_Asset->EditAttrs["class"] = "form-control";
            $this->Condition_Of_Asset->EditCustomAttributes = "";
            $curVal = trim(strval($this->Condition_Of_Asset->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->lookupCacheOption($curVal);
            } else {
                $this->Condition_Of_Asset->AdvancedSearch->ViewValue = $this->Condition_Of_Asset->Lookup !== null && is_array($this->Condition_Of_Asset->Lookup->Options) ? $curVal : null;
            }
            if ($this->Condition_Of_Asset->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Condition_Of_Asset->EditValue = array_values($this->Condition_Of_Asset->Lookup->Options);
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = "`status`" . SearchString("=", $this->Condition_Of_Asset->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
                }
                $sqlWrk = $this->Condition_Of_Asset->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Condition_Of_Asset->EditValue = $arwrk;
            }
            $this->Condition_Of_Asset->PlaceHolder = RemoveHtml($this->Condition_Of_Asset->caption());

            // Location_id
            $this->Location_id->EditAttrs["class"] = "form-control";
            $this->Location_id->EditCustomAttributes = "";
            $this->Location_id->PlaceHolder = RemoveHtml($this->Location_id->caption());

            // MDA_id
            $this->MDA_id->EditAttrs["class"] = "form-control";
            $this->MDA_id->EditCustomAttributes = "";
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

            // Category
            $this->Category->EditCustomAttributes = "";
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // Category_Details
            $this->Category_Details->EditAttrs["class"] = "form-control";
            $this->Category_Details->EditCustomAttributes = "";
            if (!$this->Category_Details->Raw) {
                $this->Category_Details->AdvancedSearch->SearchValue = HtmlDecode($this->Category_Details->AdvancedSearch->SearchValue);
            }
            $this->Category_Details->EditValue = HtmlEncode($this->Category_Details->AdvancedSearch->SearchValue);
            $this->Category_Details->PlaceHolder = RemoveHtml($this->Category_Details->caption());

            // Date_of_Acquisition
            $this->Date_of_Acquisition->EditAttrs["class"] = "form-control";
            $this->Date_of_Acquisition->EditCustomAttributes = "";
            $this->Date_of_Acquisition->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Date_of_Acquisition->AdvancedSearch->SearchValue, 0), 8));
            $this->Date_of_Acquisition->PlaceHolder = RemoveHtml($this->Date_of_Acquisition->caption());

            // Aquistion_Cost
            $this->Aquistion_Cost->EditAttrs["class"] = "form-control";
            $this->Aquistion_Cost->EditCustomAttributes = "";
            $this->Aquistion_Cost->EditValue = HtmlEncode($this->Aquistion_Cost->AdvancedSearch->SearchValue);
            $this->Aquistion_Cost->PlaceHolder = RemoveHtml($this->Aquistion_Cost->caption());

            // Additional_Cost
            $this->Additional_Cost->EditAttrs["class"] = "form-control";
            $this->Additional_Cost->EditCustomAttributes = "";
            $this->Additional_Cost->EditValue = HtmlEncode($this->Additional_Cost->AdvancedSearch->SearchValue);
            $this->Additional_Cost->PlaceHolder = RemoveHtml($this->Additional_Cost->caption());

            // Revaluation_Cost
            $this->Revaluation_Cost->EditAttrs["class"] = "form-control";
            $this->Revaluation_Cost->EditCustomAttributes = "";
            $this->Revaluation_Cost->EditValue = HtmlEncode($this->Revaluation_Cost->AdvancedSearch->SearchValue);
            $this->Revaluation_Cost->PlaceHolder = RemoveHtml($this->Revaluation_Cost->caption());

            // Updated_on
            $this->Updated_on->EditAttrs["class"] = "form-control";
            $this->Updated_on->EditCustomAttributes = "";
            $this->Updated_on->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Updated_on->AdvancedSearch->SearchValue, 7), 7));
            $this->Updated_on->PlaceHolder = RemoveHtml($this->Updated_on->caption());
        }
        if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != ROWTYPE_AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if ($this->Asset_No->Required) {
            if (!$this->Asset_No->IsDetailKey && EmptyValue($this->Asset_No->FormValue)) {
                $this->Asset_No->addErrorMessage(str_replace("%s", $this->Asset_No->caption(), $this->Asset_No->RequiredErrorMessage));
            }
        }
        if ($this->Custodian_id->Required) {
            if ($this->Custodian_id->FormValue == "") {
                $this->Custodian_id->addErrorMessage(str_replace("%s", $this->Custodian_id->caption(), $this->Custodian_id->RequiredErrorMessage));
            }
        }
        if ($this->Details_of_Asset->Required) {
            if (!$this->Details_of_Asset->IsDetailKey && EmptyValue($this->Details_of_Asset->FormValue)) {
                $this->Details_of_Asset->addErrorMessage(str_replace("%s", $this->Details_of_Asset->caption(), $this->Details_of_Asset->RequiredErrorMessage));
            }
        }
        if ($this->Asset_Status->Required) {
            if (!$this->Asset_Status->IsDetailKey && EmptyValue($this->Asset_Status->FormValue)) {
                $this->Asset_Status->addErrorMessage(str_replace("%s", $this->Asset_Status->caption(), $this->Asset_Status->RequiredErrorMessage));
            }
        }
        if ($this->Condition_Of_Asset->Required) {
            if (!$this->Condition_Of_Asset->IsDetailKey && EmptyValue($this->Condition_Of_Asset->FormValue)) {
                $this->Condition_Of_Asset->addErrorMessage(str_replace("%s", $this->Condition_Of_Asset->caption(), $this->Condition_Of_Asset->RequiredErrorMessage));
            }
        }
        if ($this->Location_id->Required) {
            if (!$this->Location_id->IsDetailKey && EmptyValue($this->Location_id->FormValue)) {
                $this->Location_id->addErrorMessage(str_replace("%s", $this->Location_id->caption(), $this->Location_id->RequiredErrorMessage));
            }
        }
        if ($this->MDA_id->Required) {
            if (!$this->MDA_id->IsDetailKey && EmptyValue($this->MDA_id->FormValue)) {
                $this->MDA_id->addErrorMessage(str_replace("%s", $this->MDA_id->caption(), $this->MDA_id->RequiredErrorMessage));
            }
        }
        if ($this->Category->Required) {
            if ($this->Category->FormValue == "") {
                $this->Category->addErrorMessage(str_replace("%s", $this->Category->caption(), $this->Category->RequiredErrorMessage));
            }
        }
        if ($this->Category_Details->Required) {
            if (!$this->Category_Details->IsDetailKey && EmptyValue($this->Category_Details->FormValue)) {
                $this->Category_Details->addErrorMessage(str_replace("%s", $this->Category_Details->caption(), $this->Category_Details->RequiredErrorMessage));
            }
        }
        if ($this->Date_of_Acquisition->Required) {
            if (!$this->Date_of_Acquisition->IsDetailKey && EmptyValue($this->Date_of_Acquisition->FormValue)) {
                $this->Date_of_Acquisition->addErrorMessage(str_replace("%s", $this->Date_of_Acquisition->caption(), $this->Date_of_Acquisition->RequiredErrorMessage));
            }
        }
        if ($this->Aquistion_Cost->Required) {
            if (!$this->Aquistion_Cost->IsDetailKey && EmptyValue($this->Aquistion_Cost->FormValue)) {
                $this->Aquistion_Cost->addErrorMessage(str_replace("%s", $this->Aquistion_Cost->caption(), $this->Aquistion_Cost->RequiredErrorMessage));
            }
        }
        if ($this->Additional_Cost->Required) {
            if (!$this->Additional_Cost->IsDetailKey && EmptyValue($this->Additional_Cost->FormValue)) {
                $this->Additional_Cost->addErrorMessage(str_replace("%s", $this->Additional_Cost->caption(), $this->Additional_Cost->RequiredErrorMessage));
            }
        }
        if ($this->Revaluation_Cost->Required) {
            if (!$this->Revaluation_Cost->IsDetailKey && EmptyValue($this->Revaluation_Cost->FormValue)) {
                $this->Revaluation_Cost->addErrorMessage(str_replace("%s", $this->Revaluation_Cost->caption(), $this->Revaluation_Cost->RequiredErrorMessage));
            }
        }
        if ($this->Updated_on->Required) {
            if (!$this->Updated_on->IsDetailKey && EmptyValue($this->Updated_on->FormValue)) {
                $this->Updated_on->addErrorMessage(str_replace("%s", $this->Updated_on->caption(), $this->Updated_on->RequiredErrorMessage));
            }
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $deleteRows = true;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAll($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }

        // Clone old rows
        $rsold = $rows;

        // Call row deleting event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $deleteRows = $this->rowDeleting($row);
                if (!$deleteRows) {
                    break;
                }
            }
        }
        if ($deleteRows) {
            $key = "";
            foreach ($rsold as $row) {
                $thisKey = "";
                if ($thisKey != "") {
                    $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
                }
                $thisKey .= $row['Assetsid'];
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }
                $deleteRows = $this->delete($row); // Delete
                if ($deleteRows === false) {
                    break;
                }
                if ($key != "") {
                    $key .= ", ";
                }
                $key .= $thisKey;
            }
        }
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }

        // Call Row Deleted event
        if ($deleteRows) {
            foreach ($rsold as $row) {
                $this->rowDeleted($row);
            }
        }

        // Write JSON for API request
        if (IsApi() && $deleteRows) {
            $row = $this->getRecordsFromRecordset($rsold);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();
        if ($this->Asset_No->CurrentValue != "") { // Check field with unique index
            $filterChk = "(`Asset_No` = '" . AdjustSql($this->Asset_No->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->Asset_No->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->Asset_No->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                $rsChk->closeCursor();
                return false;
            }
        }
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssoc($sql);
        $editRow = false;
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            $editRow = false; // Update Failed
        } else {
            // Save old values
            $this->loadDbValues($rsold);
            $rsnew = [];

            // Custodian_id
            $this->Custodian_id->setDbValueDef($rsnew, $this->Custodian_id->CurrentValue, null, $this->Custodian_id->ReadOnly);

            // Asset_Status
            $this->Asset_Status->setDbValueDef($rsnew, $this->Asset_Status->CurrentValue, "", $this->Asset_Status->ReadOnly);

            // Condition_Of_Asset
            $this->Condition_Of_Asset->setDbValueDef($rsnew, $this->Condition_Of_Asset->CurrentValue, "", $this->Condition_Of_Asset->ReadOnly);

            // Updated_on
            $this->Updated_on->CurrentValue = CurrentDate();
            $this->Updated_on->setDbValueDef($rsnew, $this->Updated_on->CurrentValue, null);

            // Call Row Updating event
            $updateRow = $this->rowUpdating($rsold, $rsnew);
            if ($updateRow) {
                if (count($rsnew) > 0) {
                    try {
                        $editRow = $this->update($rsnew, "", $rsold);
                    } catch (\Exception $e) {
                        $this->setFailureMessage($e->getMessage());
                    }
                } else {
                    $editRow = true; // No field to update
                }
                if ($editRow) {
                }
            } else {
                if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($Language->phrase("UpdateCancelled"));
                }
                $editRow = false;
            }
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        if ($editRow) {
            if ($this->SendEmail) {
                $this->sendEmailOnEdit($rsold, $rsnew);
            }
        }

        // Clean upload path if any
        if ($editRow) {
        }

        // Write JSON for API request
        if (IsApi() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $editRow;
    }

    // Load row hash
    protected function loadRowHash()
    {
        $filter = $this->getRecordFilter();

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $row = $conn->fetchAssoc($sql);
        $this->HashValue = $row ? $this->getRowHash($row) : ""; // Get hash value for record
    }

    // Get Row Hash
    public function getRowHash(&$rs)
    {
        if (!$rs) {
            return "";
        }
        $row = ($rs instanceof Recordset) ? $rs->fields : $rs;
        $hash = "";
        $hash .= GetFieldHash($row['Custodian_id']); // Custodian_id
        $hash .= GetFieldHash($row['Asset_Status']); // Asset_Status
        $hash .= GetFieldHash($row['Condition_Of_Asset']); // Condition_Of_Asset
        $hash .= GetFieldHash($row['Updated_on']); // Updated_on
        return md5($hash);
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;
        if ($this->Asset_No->CurrentValue != "") { // Check field with unique index
            $filter = "(`Asset_No` = '" . AdjustSql($this->Asset_No->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->Asset_No->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->Asset_No->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from rsold
        $this->loadDbValues($rsold);
        if ($rsold) {
        }
        $rsnew = [];

        // Asset_No
        $this->Asset_No->setDbValueDef($rsnew, $this->Asset_No->CurrentValue, null, false);

        // Custodian_id
        $this->Custodian_id->setDbValueDef($rsnew, $this->Custodian_id->CurrentValue, null, false);

        // Details_of_Asset
        $this->Details_of_Asset->setDbValueDef($rsnew, $this->Details_of_Asset->CurrentValue, "", false);

        // Asset_Status
        $this->Asset_Status->setDbValueDef($rsnew, $this->Asset_Status->CurrentValue, "", strval($this->Asset_Status->CurrentValue) == "");

        // Condition_Of_Asset
        $this->Condition_Of_Asset->setDbValueDef($rsnew, $this->Condition_Of_Asset->CurrentValue, "", strval($this->Condition_Of_Asset->CurrentValue) == "");

        // Location_id
        $this->Location_id->setDbValueDef($rsnew, $this->Location_id->CurrentValue, 0, false);

        // MDA_id
        $this->MDA_id->setDbValueDef($rsnew, $this->MDA_id->CurrentValue, 0, false);

        // Category
        $this->Category->setDbValueDef($rsnew, $this->Category->CurrentValue, "", false);

        // Category_Details
        $this->Category_Details->setDbValueDef($rsnew, $this->Category_Details->CurrentValue, null, false);

        // Date_of_Acquisition
        $this->Date_of_Acquisition->setDbValueDef($rsnew, UnFormatDateTime($this->Date_of_Acquisition->CurrentValue, 0), CurrentDate(), false);

        // Aquistion_Cost
        $this->Aquistion_Cost->setDbValueDef($rsnew, $this->Aquistion_Cost->CurrentValue, 0, false);

        // Additional_Cost
        $this->Additional_Cost->setDbValueDef($rsnew, $this->Additional_Cost->CurrentValue, null, false);

        // Revaluation_Cost
        $this->Revaluation_Cost->setDbValueDef($rsnew, $this->Revaluation_Cost->CurrentValue, null, false);

        // Updated_on
        $this->Updated_on->CurrentValue = CurrentDate();
        $this->Updated_on->setDbValueDef($rsnew, $this->Updated_on->CurrentValue, null);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        $addRow = false;
        if ($insertRow) {
            try {
                $addRow = $this->insert($rsnew);
            } catch (\Exception $e) {
                $this->setFailureMessage($e->getMessage());
            }
            if ($addRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Clean upload path if any
        if ($addRow) {
        }

        // Write JSON for API request
        if (IsApi() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            WriteJson(["success" => true, $this->TableVar => $row]);
        }
        return $addRow;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->Assetsid->AdvancedSearch->load();
        $this->Asset_No->AdvancedSearch->load();
        $this->Custodian_id->AdvancedSearch->load();
        $this->Details_of_Asset->AdvancedSearch->load();
        $this->Asset_Status->AdvancedSearch->load();
        $this->Condition_Of_Asset->AdvancedSearch->load();
        $this->Location_id->AdvancedSearch->load();
        $this->MDA_Parent->AdvancedSearch->load();
        $this->MDA_id->AdvancedSearch->load();
        $this->MDA_temp->AdvancedSearch->load();
        $this->Category->AdvancedSearch->load();
        $this->Category_Details->AdvancedSearch->load();
        $this->Category_Temp->AdvancedSearch->load();
        $this->Make->AdvancedSearch->load();
        $this->Model->AdvancedSearch->load();
        $this->YearofManufacture->AdvancedSearch->load();
        $this->Colour->AdvancedSearch->load();
        $this->EngineNumber->AdvancedSearch->load();
        $this->ChasisNumber->AdvancedSearch->load();
        $this->CivilianPlateNumber->AdvancedSearch->load();
        $this->GovtPlateNumber->AdvancedSearch->load();
        $this->Date_of_Acquisition->AdvancedSearch->load();
        $this->Aquistion_Cost->AdvancedSearch->load();
        $this->Additional_Cost->AdvancedSearch->load();
        $this->Revaluation_Cost->AdvancedSearch->load();
        $this->Remarks->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->Created_on->AdvancedSearch->load();
        $this->Updated_on->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        $pageUrl = $this->pageUrl();
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.fverifyassetslist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.fverifyassetslist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.fverifyassetslist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
            } else {
                return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ",url:'" . $pageUrl . "export=email&amp;custom=1'" : "";
            return '<button id="emf_verifyassets" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_verifyassets\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.fverifyassetslist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to Html
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = true;

        // Export to Xml
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to Csv
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = false;

        // Export to Pdf
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl();
        $this->SearchOptions = new ListOptions("div");
        $this->SearchOptions->TagClassName = "ew-search-option";

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fverifyassetslistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        $item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction) {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($return = false)
    {
        global $Language;
        $utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");

        // Load recordset
        $this->TotalRecords = $this->listRecordCount();
        $this->StartRecord = 1;

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        $this->ExportDoc = GetExportDocument($this, "h");
        $doc = &$this->ExportDoc;
        if (!$doc) {
            $this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
        }
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $this->ExportDoc->ExportCustom = !$this->pageExporting();
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Close recordset
        $rs->close();

        // Call Page Exported server event
        $this->pageExported();

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Clean output buffer (without destroying output buffer)
        $buffer = ob_get_contents(); // Save the output buffer
        if (!Config("DEBUG") && $buffer) {
            ob_clean();
        }

        // Write debug message if enabled
        if (Config("DEBUG") && !$this->isExport("pdf")) {
            echo GetDebugMessage();
        }

        // Output data
        if ($this->isExport("email")) {
            // Export-to-email disabled
        } else {
            $doc->export();
            if ($return) {
                RemoveHeader("Content-Type"); // Remove header
                RemoveHeader("Content-Disposition");
                $content = ob_get_contents();
                if ($content) {
                    ob_clean();
                }
                if ($buffer) {
                    echo $buffer; // Resume the output buffer
                }
                return $content;
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("dashboard2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup !== null && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Custodian_id":
                    break;
                case "x_Asset_Status":
                    break;
                case "x_Condition_Of_Asset":
                    break;
                case "x_Location_id":
                    break;
                case "x_MDA_id":
                    break;
                case "x_Category":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll(\PDO::FETCH_BOTH);
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $ar[strval($row[0])] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        if ($this->isPageRequest()) { // Validate request
            $startRec = Get(Config("TABLE_START_REC"));
            $pageNo = Get(Config("TABLE_PAGE_NO"));
            if ($pageNo !== null) { // Check for "pageno" parameter first
                if (is_numeric($pageNo)) {
                    $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                    if ($this->StartRecord <= 0) {
                        $this->StartRecord = 1;
                    } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                        $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                    }
                    $this->setStartRecordNumber($this->StartRecord);
                }
            } elseif ($startRec !== null) { // Check for "start" parameter
                $this->StartRecord = $startRec;
                $this->setStartRecordNumber($this->StartRecord);
            }
        }
        $this->StartRecord = $this->getStartRecordNumber();

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
            $this->setStartRecordNumber($this->StartRecord);
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == 'success') {
            //$msg = "your success message";
        } elseif ($type == 'failure') {
            //$msg = "your failure message";
        } elseif ($type == 'warning') {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
         //hide export. This is for CRUD only
        $this->ExportOptions->Items["excel"]->Visible = FALSE;
        $this->ExportOptions->Items["pdf"]->Visible = FALSE;
        $this->ExportOptions->Items["print"]->Visible = FALSE;
        $this->ExportOptions->Items["html"]->Visible = FALSE;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
    //set current username variable
    $vintousername= CurrentUserName();

    //get userid
    $vintouserid = ExecuteScalar("SELECT userid FROM reportuserstbl WHERE Username = '$vintousername'");

    // Get CUSTODIAN ID
    $vintocustodianid = ExecuteScalar("SELECT id FROM custodianstbl WHERE User_id = '$vintouserid'");
    $vintocustodianidonassettbl = ExecuteScalar("SELECT Custodian_id FROM assetstbl WHERE Custodian_id = '$vintocustodianid'");
    if($vintocustodianidonassettbl)
    {
    // display print recipt if user have assets in their custody only .
      // add print link to header
    $header='<a class="ew-export-link ew-print dropdown-item" href="printassets" data-caption="Print Asset Reciept" target="_blank" data-original-title="" title=""><i data-phrase="PrinterFriendly" class="icon-print ew-icon mr-2" data-caption="Print Asset Reciept"></i>Print Asset Reciept</a>';
    }

        // add print link to hrader
    //$header='<a class="ew-export-link ew-print dropdown-item" href="print2" data-caption="Print Asset Reciept" target="_blank" data-original-title="" title=""><i data-phrase="PrinterFriendly" class="icon-print ew-icon mr-2" data-caption="Print Asset Reciept"></i>Print Asset Reciept</a>';

      //  $header = "<span class='icon-print ew-icon mr-2'></spann><button class=' btn btn primary'><i>Print Asset Reciept</i></button>";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
      /*
        $footer = ' <input type="checkbox" id="checkBoxID" class="btn btn-danger" checked>
       <span><strong>I hereby confirm that the above listed assets are in my custody, except those that I have unchecked</strong></span>
      <input class="" type="submit" value="I confirm" id="btn"/>
       ';
       */
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in CustomError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->Add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->MoveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $this->ExportDoc = export document object
    public function pageExporting()
    {
        //$this->ExportDoc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $this->ExportDoc = export document object
    public function rowExport($rs)
    {
        //$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $this->ExportDoc = export document object
    public function pageExported()
    {
        //$this->ExportDoc->Text .= "my footer"; // Export footer
        //Log($this->ExportDoc->Text);
    }

    // Page Importing event
    public function pageImporting($reader, &$options)
    {
        //var_dump($reader); // Import data reader
        //var_dump($options); // Show all options for importing
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($reader, $results)
    {
        //var_dump($reader); // Import data reader
        //var_dump($results); // Import results
    }
}
